#include "config.glsl"
#include "../lib/coord.glsl"
#include "../lib/ambient.glsl"
#include "../lib/lighting.glsl"

uniform int renderStage;

struct InOut {
    vec2 texcoord;
    vec2 lmcoord;
    vec4 glcolor;
    vec3 normal;
    vec3 position;
};

#if defined(VSH)

out InOut vs_out;

void main() {
    vs_out.texcoord = (gl_TextureMatrix[0] * gl_MultiTexCoord0).xy;

    vs_out.lmcoord = (gl_TextureMatrix[1] * gl_MultiTexCoord1).xy;
    vs_out.lmcoord = vs_out.lmcoord / (30.0 / 32.0) - (1.0 / 32.0);


    vs_out.glcolor = gl_Color;
    vs_out.normal = gl_NormalMatrix * gl_Normal;
    vs_out.normal = mat3(gl_ModelViewMatrixInverse) * vs_out.normal;
    vs_out.position = gl_Vertex.xyz;


    gl_Position = gl_Vertex;
    gl_Position = gl_ModelViewMatrix * gl_Position;
    gl_Position = gl_ProjectionMatrix * gl_Position;
}

#elif defined(FSH)

uniform sampler2D gtexture;

in InOut vs_out;

/* RENDERTARGETS: 0,1,2,3 */
layout(location = 0) out vec4 color;
layout(location = 1) out vec4 lightmapData;
layout(location = 2) out vec4 encodedNormal;
layout(location = 3) out vec4 translucentData;//sky,cloud,todo


void main() {
    color = texture(gtexture, vs_out.texcoord) * vs_out.glcolor;
    if (color.a < alphaTestRef) {
        discard;
    }

    lightmapData = vec4(vs_out.lmcoord, 0.0, 1.0);
    encodedNormal = vec4(vs_out.normal * 0.5 + 0.5, 1.0);

    switch(renderStage) {
        case MC_RENDER_STAGE_SKY:
        case MC_RENDER_STAGE_SUNSET:
        color = vec4(0.0, 0.0, 0.0, 1.0);
        translucentData = vec4(1.0, 0.0, 0.0, 1.0);
        break;
        /*
        case MC_RENDER_STAGE_CLOUDS:
        {
            float viewDist = length(vs_out.position.xz);

            float begin = 0;
            
            color.rgb *= 1.3;
            color.a *= 1.0 - max(viewDist - begin, 0) / (CLOUD_DISTANCE - begin);
            translucentData = vec4(0.0, 1.0, 0.0, color.a);
        }
        break;
        */
        default:
        {
            translucentData = vec4(0.0, 0.0, 0.0, color.a);

            float viewDist = length(vs_out.position.xz);
            vec3 lightVector = normalize(shadowLightPosition);
            vec3 worldLightVector = mat3(gbufferModelViewInverse) * lightVector;
            float blockDirectionShadow = max(dot(worldLightVector, vs_out.normal), 0);//0~1
            
            #if RENDERING_MODE == RENDERING_MODE_FORWARD

            vec3 lighting = getLighting(vs_out.position, viewDist, lightmapData.xy, blockDirectionShadow);
            color.rgb *= lighting;
            
            float fog = getFog(vs_out.position);
            color.rgb = mix(color.rgb, getFogColor(), fog);
            if (fog != 0) {
                color.a = mix(color.a, 1, fog);
            } 

            #endif
        }
        break;
    }

}

#endif