/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.client.entity.render;

import com.jdolphin.ricksportalgun.client.entity.model.PortalEntityModel;
import com.jdolphin.ricksportalgun.common.customization.PGPortalType;
import com.jdolphin.ricksportalgun.common.entity.PortalEntity;
import com.jdolphin.ricksportalgun.common.util.helper.PGHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.DyeColor;

public class PortalEntityRenderer
extends EntityRenderer<PortalEntity> {
    public static final ResourceLocation PORTAL_TEXTURE = PGHelper.id("textures/entity/portal.png");
    public PortalEntityModel model;
    private final List<String> names = List.of(new String[]{"_jeb", "rainbow", "rgb", "colourful", "colorful"});

    public PortalEntityRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
        this.model = new PortalEntityModel(pContext.m_174023_(PortalEntityModel.LAYER_LOCATION));
    }

    public ResourceLocation getTextureLocation(PortalEntity entity) {
        return PORTAL_TEXTURE;
    }

    protected void openAnimation(PortalEntity entity, PoseStack stack) {
        float f;
        if (!entity.exists() && (double)entity.f_19797_ < (double)entity.getLifetime() * 0.1) {
            f = Mth.m_14179_((float)((float)entity.f_19797_ / 20.0f), (float)0.0f, (float)1.0f);
            f = Mth.m_14036_((float)f, (float)0.0f, (float)1.0f);
            f *= f;
            f *= f;
            stack.m_85841_(f, f, f);
        }
        if ((double)entity.f_19797_ > (double)entity.getLifetime() * 0.9) {
            f = Mth.m_14179_((float)((float)entity.f_19797_ / 20.0f), (float)1.0f, (float)0.0f);
            f = Mth.m_14036_((float)f, (float)1.0f, (float)0.0f);
            f *= f;
            f *= f;
            stack.m_85841_(f, f, f);
        }
    }

    public void render(PortalEntity entity, float yaw, float partialTick, PoseStack stack, MultiBufferSource source, int packedLight) {
        PGPortalType type = entity.getPortalType();
        if (type.getModel() == null && type.needsModel()) {
            type.setModel((Model)this.model);
        }
        this.openAnimation(entity, stack);
        int color = entity.getColor();
        float r = (float)FastColor.ARGB32.m_13665_((int)color) / 255.0f;
        float g = (float)FastColor.ARGB32.m_13667_((int)color) / 255.0f;
        float b = (float)FastColor.ARGB32.m_13669_((int)color) / 255.0f;
        if (this.names.contains(entity.m_7755_().getString().toLowerCase())) {
            int i = entity.f_19797_ / 25 + entity.m_19879_();
            int j = DyeColor.values().length;
            int k = i % j;
            int l = (i + 1) % j;
            float f3 = ((float)(entity.f_19797_ % 25) + partialTick) / 25.0f;
            float[] afloat1 = Sheep.m_29829_((DyeColor)DyeColor.m_41053_((int)k));
            float[] afloat2 = Sheep.m_29829_((DyeColor)DyeColor.m_41053_((int)l));
            r = afloat1[0] * (1.0f - f3) + afloat2[0] * f3;
            g = afloat1[1] * (1.0f - f3) + afloat2[1] * f3;
            b = afloat1[2] * (1.0f - f3) + afloat2[2] * f3;
        }
        type.renderPortal(entity, yaw, partialTick, stack, source, packedLight, r, g, b);
        super.m_7392_((Entity)entity, yaw, partialTick, stack, source, 0xF000F0);
    }
}

