/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.client.screen.portalgun;

import com.jdolphin.ricksportalgun.client.screen.AbstractBaseScreen;
import com.jdolphin.ricksportalgun.client.screen.widget.PGCycleButton;
import com.jdolphin.ricksportalgun.client.screen.widget.PGImageButton;
import com.jdolphin.ricksportalgun.client.screen.widget.PGTextButton;
import com.jdolphin.ricksportalgun.client.screen.widget.SuggestionTextFieldWidget;
import com.jdolphin.ricksportalgun.common.customization.PortalGunStyle;
import com.jdolphin.ricksportalgun.common.init.PGUpgradeTypes;
import com.jdolphin.ricksportalgun.common.item.PortalGunItem;
import com.jdolphin.ricksportalgun.common.packet.serverbound.SBLocatePacket;
import com.jdolphin.ricksportalgun.common.packet.serverbound.SBOpenCoordGuiPacket;
import com.jdolphin.ricksportalgun.common.util.helper.GuiHelper;
import com.jdolphin.ricksportalgun.common.util.helper.PGHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.ItemStack;

public class LocatorScreen
extends AbstractBaseScreen {
    private SuggestionTextFieldWidget input;
    private PGTextButton select;
    private PGTextButton cancel;
    private PGCycleButton<LocatorType> locatorType;
    private final List<String> playerList;
    private final List<String> biomeList;
    private final List<String> structureList;
    private PGImageButton backButton;

    public LocatorScreen(List<String> playerList, List<String> biomeList, List<String> structureList) {
        super("menu.ricksportalgun.player_locator");
        this.playerList = playerList;
        this.biomeList = biomeList;
        this.structureList = structureList;
    }

    private List<String> getListFromType(LocatorType type) {
        switch (type) {
            case STRUCTURE: {
                return this.structureList;
            }
            case PLAYER: {
                return this.playerList;
            }
        }
        return this.biomeList;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        Optional optional = this.m_94729_(mouseX, mouseY);
        if (optional.isEmpty()) {
            this.input.m_93692_(false);
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    private LocatorType[] getAllowedLocators() {
        ItemStack stack = this.getItemStack();
        boolean canPlayerLocate = PortalGunItem.getUpgrades(stack).contains(PGUpgradeTypes.PLAYER_LOC.getUpgradeTag());
        boolean canStructureLocate = PortalGunItem.getUpgrades(stack).contains(PGUpgradeTypes.STRUCTURE_LOC.getUpgradeTag());
        if (canPlayerLocate && canStructureLocate) {
            return LocatorType.values();
        }
        if (!canPlayerLocate && !canStructureLocate) {
            return new LocatorType[]{LocatorType.BIOME};
        }
        if (canPlayerLocate && !canStructureLocate) {
            return new LocatorType[]{LocatorType.BIOME, LocatorType.PLAYER};
        }
        return new LocatorType[0];
    }

    protected void m_7856_() {
        this.locatorType = (PGCycleButton)this.m_142416_((GuiEventListener)PGCycleButton.builder(LocatorType::getDisplayName).withValues((LocatorType[])this.getAllowedLocators()).create(this.f_96543_ / 2 - 64, this.f_96544_ / 2 - 64, 128, 20, (Component)Component.m_237115_((String)"ricksportalgun.button.locator"), (button, type) -> {
            List<String> list = this.getListFromType((LocatorType)((Object)type));
            this.input.setSuggestions(list);
        }));
        this.input = (SuggestionTextFieldWidget)this.m_7787_((GuiEventListener)new SuggestionTextFieldWidget(this.f_96543_ / 2 - 64, this.f_96544_ / 2 - 32, 128, 24, Component.m_237115_((String)"chat.editBox"), this.getListFromType(this.locatorType.getValue())));
        this.m_142416_((GuiEventListener)this.input.getSuggestionList());
        this.select = (PGTextButton)this.m_142416_((GuiEventListener)new PGTextButton(this.f_96543_ / 2 - 136, this.f_96544_ / 2 + 64, 128, 20, (Component)Component.m_237115_((String)"ricksportalgun.button.select"), button -> {
            this.setCoords();
            this.m_7379_();
        }, this.f_96547_));
        this.backButton = (PGImageButton)this.m_142416_((GuiEventListener)new PGImageButton(this.f_96543_ / 2 - 140, this.f_96544_ / 2 - 96, 20, 20, (Component)Component.m_237115_((String)"ricksportalgun.button.back"), button -> {
            SBOpenCoordGuiPacket packet = new SBOpenCoordGuiPacket();
            PGHelper.sendPacketToServer(packet);
        }, 20, 20, BACK_BUTTON_TEXTURE));
        this.cancel = (PGTextButton)this.m_142416_((GuiEventListener)new PGTextButton(this.f_96543_ / 2 + 8, this.f_96544_ / 2 + 64, 128, 20, (Component)Component.m_237115_((String)"ricksportalgun.button.cancel"), button -> this.m_7379_(), this.f_96547_));
        PortalGunStyle style = this.getStyle();
        this.input.m_94199_(256);
        this.input.m_94182_(true);
        this.input.m_94151_(s -> this.input.update());
        this.locatorType.setRenderBackground(false);
        this.locatorType.setTextColor(style.textColor());
        this.locatorType.setRenderArrows(true);
        this.input.getSuggestionList().setBorderColor(style.highlightColor());
        this.backButton.setColor(style.highlightColor());
        this.backButton.setRenderBackground(false);
        GuiHelper.setTooltip((AbstractWidget)this.backButton, (Component)Component.m_237115_((String)"ricksportalgun.button.back"));
    }

    public void m_88315_(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        PortalGunStyle style = this.getStyle();
        graphics.m_280509_(this.f_96543_ / 2 - 154, this.f_96544_ / 2 - 110, this.f_96543_ / 2 + 165, this.f_96544_ / 2 + 100, style.bgColor());
        graphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"menu.ricksportalgun.locator"), this.f_96543_ / 2, this.f_96544_ / 2 - 92, style.textColor());
        if (this.input != null) {
            this.input.m_88315_(graphics, pMouseX, pMouseY, pPartialTick);
        }
        GuiHelper.renderOutline(graphics, (AbstractWidget)this.select, style.highlightColor());
        GuiHelper.renderOutline(graphics, (AbstractWidget)this.cancel, style.highlightColor());
        GuiHelper.renderOutline(graphics, this.locatorType, style.highlightColor());
        GuiHelper.renderOutline(graphics, (AbstractWidget)this.input, style.highlightColor());
        GuiHelper.renderOutline(graphics, (AbstractWidget)this.backButton, style.highlightColor());
        Style guiStyle = GuiHelper.getStyle(pMouseX, pMouseY);
        if (guiStyle != null && guiStyle.m_131186_() != null) {
            this.m_280264_(graphics, pMouseX, pMouseY, pPartialTick);
        }
        RenderSystem.enableBlend();
        graphics.m_280163_(BG_LOCATION, this.f_96543_ / 2 - 158, this.f_96544_ / 2 - 115, 0.0f, 0.0f, 330, 224, 330, 224);
        RenderSystem.disableBlend();
        super.m_88315_(graphics, pMouseX, pMouseY, pPartialTick);
    }

    public void setCoords() {
        SBLocatePacket packet = new SBLocatePacket(this.input.m_94155_(), this.locatorType.getValue().ordinal());
        PGHelper.sendPacketToServer(packet);
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        switch (pKeyCode) {
            case 257: 
            case 335: {
                if (this.m_7222_() instanceof Button) {
                    return super.m_7933_(pKeyCode, pScanCode, pModifiers);
                }
                this.setCoords();
            }
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    public static enum LocatorType {
        BIOME("biome"),
        PLAYER("player"),
        STRUCTURE("structure");

        final String key;

        private LocatorType(String key) {
            this.key = key;
        }

        public Component getDisplayName() {
            return Component.m_237115_((String)("ricksportalgun.button.locator." + this.key));
        }
    }
}

