/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.client.screen.portalgun.settings;

import com.jdolphin.ricksportalgun.PGConstants;
import com.jdolphin.ricksportalgun.client.entity.render.PortalEntityRenderer;
import com.jdolphin.ricksportalgun.client.screen.AbstractBaseScreen;
import com.jdolphin.ricksportalgun.client.screen.portalgun.settings.CustomizationSettingsScreen;
import com.jdolphin.ricksportalgun.client.screen.widget.PGImageButton;
import com.jdolphin.ricksportalgun.client.screen.widget.PGSlider;
import com.jdolphin.ricksportalgun.client.screen.widget.PGTextButton;
import com.jdolphin.ricksportalgun.common.customization.PortalGunStyle;
import com.jdolphin.ricksportalgun.common.init.PGTags;
import com.jdolphin.ricksportalgun.common.packet.serverbound.SBColourPacket;
import com.jdolphin.ricksportalgun.common.util.helper.GuiHelper;
import com.jdolphin.ricksportalgun.common.util.helper.PGHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.ItemStack;

public class ColourPickingScreen
extends AbstractBaseScreen {
    private PGSlider r;
    private PGSlider g;
    private PGSlider b;
    private PGSlider size;
    private PGTextButton reset;
    private PGTextButton select;
    private PGTextButton cancel;
    private PGImageButton backButton;

    public ColourPickingScreen() {
        super((Component)Component.m_237115_((String)"menu.ricksportalgun.colour_select"));
    }

    protected void m_7856_() {
        assert (this.f_96541_ != null && this.f_96541_.f_91074_ != null);
        ItemStack stack = this.getItemStack();
        CompoundTag tag = stack.m_41784_();
        int color = tag.m_128441_("Color") ? tag.m_128451_("Color") : Color.GREEN.getRGB();
        this.r = (PGSlider)this.m_142416_((GuiEventListener)new PGSlider(this.f_96543_ / 2 - 44, this.f_96544_ / 2 - 60, 36, 20, (Component)Component.m_237119_(), new Color(color).getRed(), 0.0, 255.0, false));
        this.g = (PGSlider)this.m_142416_((GuiEventListener)new PGSlider(this.f_96543_ / 2 - 44, this.f_96544_ / 2 - 36, 36, 20, (Component)Component.m_237119_(), new Color(color).getGreen(), 0.0, 255.0, false));
        this.b = (PGSlider)this.m_142416_((GuiEventListener)new PGSlider(this.f_96543_ / 2 - 44, this.f_96544_ / 2 - 12, 36, 20, (Component)Component.m_237119_(), new Color(color).getBlue(), 0.0, 255.0, false));
        this.size = (PGSlider)this.m_142416_((GuiEventListener)new PGSlider(this.f_96543_ / 2 - 44, this.f_96544_ / 2 + 12, 36, 20, (Component)Component.m_237119_(), 1.0, 1.0, 3.0, false));
        this.select = (PGTextButton)this.m_142416_((GuiEventListener)new PGTextButton(this.f_96543_ / 2 - 136, this.f_96544_ / 2 + 64, 128, 20, (Component)Component.m_237115_((String)"ricksportalgun.button.select"), button -> {
            if (stack.m_204117_(PGTags.Items.PORTAL_GUNS)) {
                SBColourPacket packet = new SBColourPacket(this.getColor());
                PGHelper.sendPacketToServer(packet);
                this.m_7379_();
            }
        }, this.f_96547_));
        this.cancel = (PGTextButton)this.m_142416_((GuiEventListener)new PGTextButton(this.f_96543_ / 2 + 8, this.f_96544_ / 2 + 64, 128, 20, (Component)Component.m_237115_((String)"ricksportalgun.button.cancel"), button -> this.m_7379_(), this.f_96547_));
        this.reset = (PGTextButton)this.m_142416_((GuiEventListener)new PGTextButton(this.f_96543_ / 2 + 72, this.f_96544_ / 2 + 42, 64, 20, (Component)Component.m_237115_((String)"ricksportalgun.button.colour.reset"), button -> {
            int rgb = tag.m_128441_("DefaultColor") ? tag.m_128451_("DefaultColor") : Color.GREEN.getRGB();
            try {
                this.r.m_93611_(FastColor.ARGB32.m_13665_((int)rgb));
                this.g.m_93611_(FastColor.ARGB32.m_13667_((int)rgb));
                this.b.m_93611_(FastColor.ARGB32.m_13669_((int)rgb));
            }
            catch (Exception e) {
                PGConstants.LOGGER.warn(e.getMessage());
            }
        }, this.f_96547_));
        this.backButton = (PGImageButton)this.m_142416_((GuiEventListener)new PGImageButton(this.f_96543_ / 2 - 140, this.f_96544_ / 2 - 96, 20, 20, (Component)Component.m_237115_((String)"ricksportalgun.button.back"), button -> this.f_96541_.m_91152_((Screen)new CustomizationSettingsScreen()), 20, 20, BACK_BUTTON_TEXTURE));
        PortalGunStyle style = this.getStyle();
        this.select.setTextColour(style.textColor());
        this.reset.setTextColour(style.textColor());
        this.cancel.setTextColour(style.textColor());
        this.r.setRenderBG(false);
        this.g.setRenderBG(false);
        this.b.setRenderBG(false);
        this.size.setRenderBG(false);
        this.r.setStyle(style);
        this.g.setStyle(style);
        this.b.setStyle(style);
        this.size.setStyle(style);
        this.backButton.setColor(style.highlightColor());
        this.backButton.setRenderBackground(false);
        GuiHelper.setTooltip((AbstractWidget)this.backButton, (Component)Component.m_237115_((String)"ricksportalgun.button.back"));
    }

    public int getColor() {
        try {
            return new Color((int)this.r.getValue(), (int)this.g.getValue(), (int)this.b.getValue()).getRGB();
        }
        catch (NumberFormatException e) {
            GuiHelper.drawWhiteCenteredString(new GuiGraphics(Minecraft.m_91087_(), Minecraft.m_91087_().m_91269_().m_110104_()), (Component)Component.m_237110_((String)"error.ricksportalgun.color", (Object[])new Object[]{e.getMessage().toLowerCase()}), this.f_96543_ / 2, 55);
            return 0;
        }
    }

    public void m_88315_(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        PortalGunStyle style = this.getStyle();
        graphics.m_280509_(this.f_96543_ / 2 - 154, this.f_96544_ / 2 - 110, this.f_96543_ / 2 + 165, this.f_96544_ / 2 + 100, style.bgColor());
        graphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"menu.ricksportalgun.colour_select"), this.f_96543_ / 2, this.f_96544_ / 2 - 92, style.textColor());
        graphics.m_280430_(this.f_96547_, (Component)Component.m_237110_((String)"ricksportalgun.red", (Object[])new Object[]{""}), this.f_96543_ / 2 - 110, this.r.m_252907_() + 4, style.textColor());
        graphics.m_280430_(this.f_96547_, (Component)Component.m_237110_((String)"ricksportalgun.green", (Object[])new Object[]{""}), this.f_96543_ / 2 - 110, this.g.m_252907_() + 4, this.getStyle().textColor());
        graphics.m_280430_(this.f_96547_, (Component)Component.m_237110_((String)"ricksportalgun.blue", (Object[])new Object[]{""}), this.f_96543_ / 2 - 110, this.b.m_252907_() + 4, this.getStyle().textColor());
        graphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"ricksportalgun.button.settings.customization.color.size"), this.f_96543_ / 2 - 110, this.size.m_252907_() + 4, this.getStyle().textColor());
        GuiHelper.renderOutline(graphics, (AbstractWidget)this.select, style.highlightColor());
        GuiHelper.renderOutline(graphics, (AbstractWidget)this.cancel, style.highlightColor());
        GuiHelper.renderOutline(graphics, (AbstractWidget)this.reset, style.highlightColor());
        GuiHelper.renderOutline(graphics, (AbstractWidget)this.backButton, style.highlightColor());
        GuiHelper.renderWidgets(graphics, pMouseX, pMouseY, pPartialTick, new AbstractWidget[]{this.r, this.g, this.b});
        RenderSystem.enableBlend();
        graphics.m_280163_(BG_LOCATION, this.f_96543_ / 2 - 158, this.f_96544_ / 2 - 115, 0.0f, 0.0f, 330, 224, 330, 224);
        RenderSystem.disableBlend();
        int x = 64;
        int y = 82;
        int multiplier = this.size.getValueInt();
        int color = this.getColor();
        float r = (float)FastColor.ARGB32.m_13665_((int)color) / 255.0f;
        float g = (float)FastColor.ARGB32.m_13667_((int)color) / 255.0f;
        float b = (float)FastColor.ARGB32.m_13669_((int)color) / 255.0f;
        float a = (float)FastColor.ARGB32.m_13655_((int)color) / 255.0f;
        graphics.m_280246_(r, g, b, a);
        graphics.m_280163_(PortalEntityRenderer.PORTAL_TEXTURE, this.f_96543_ / 2 + 10, this.f_96544_ / 2 - 64, 0.0f, 0.0f, x * multiplier, y, x * multiplier, y);
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        Style guiStyle = GuiHelper.getStyle(pMouseX, pMouseY);
        if (guiStyle != null && guiStyle.m_131186_() != null) {
            this.m_280264_(graphics, pMouseX, pMouseY, pPartialTick);
        }
        super.m_88315_(graphics, pMouseX, pMouseY, pPartialTick);
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        switch (pKeyCode) {
            case 257: 
            case 335: {
                if (this.m_7222_() instanceof Button) {
                    return super.m_7933_(pKeyCode, pScanCode, pModifiers);
                }
                SBColourPacket packet = new SBColourPacket(this.getColor());
                PGHelper.sendPacketToServer(packet);
            }
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }
}

