/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.init;

import com.jdolphin.ricksportalgun.common.item.upgrade.types.CreativeUpgrade;
import com.jdolphin.ricksportalgun.common.item.upgrade.types.PreConditionUpgrade;
import com.jdolphin.ricksportalgun.common.item.upgrade.types.UpgradeType;
import com.jdolphin.ricksportalgun.common.util.helper.PGHelper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class PGUpgradeTypes {
    public static final Map<ResourceLocation, UpgradeType> UPGRADE_TYPES = new HashMap<ResourceLocation, UpgradeType>();
    public static final UpgradeType SETTINGS = PGUpgradeTypes.registerSimple("settings", (Component)Component.m_237115_((String)"tooltip.ricksportalgun.upgrade.settings"), "settings");
    public static final UpgradeType WAYPOINTS = PGUpgradeTypes.registerSimple("waypoints", (Component)Component.m_237115_((String)"tooltip.ricksportalgun.upgrade.waypoints"), "waypoints");
    public static final UpgradeType MAX_FUEL = PGUpgradeTypes.registerSimple("max_fuel", (Component)Component.m_237115_((String)"tooltip.ricksportalgun.upgrade.max_fuel"), "fuel");
    public static final UpgradeType CREATIVE = PGUpgradeTypes.registerCreative("creative", (Component)Component.m_237115_((String)"tooltip.ricksportalgun.upgrade.creative"));
    public static final UpgradeType BIOME_LOC = PGUpgradeTypes.registerSimple("biome_loc", (Component)Component.m_237115_((String)"tooltip.ricksportalgun.upgrade.biome_loc"), "biome_loc");
    public static final UpgradeType PLAYER_LOC = PGUpgradeTypes.registerPreCondition("player_loc", (Component)Component.m_237115_((String)"tooltip.ricksportalgun.upgrade.player_loc"), "player_loc", "biome_loc");
    public static final UpgradeType STRUCTURE_LOC = PGUpgradeTypes.registerPreCondition("structure_loc", (Component)Component.m_237115_((String)"tooltip.ricksportalgun.upgrade.structure_loc"), "structure_loc", "player_loc");
    public static final UpgradeType DIM_1 = PGUpgradeTypes.registerSimple("dim_1", (Component)Component.m_237115_((String)"tooltip.ricksportalgun.upgrade.dim_1"), "dim_1");
    public static final UpgradeType DIM_2 = PGUpgradeTypes.registerPreCondition("dim_2", (Component)Component.m_237115_((String)"tooltip.ricksportalgun.upgrade.dim_2"), "dim_2", "dim_1");

    private static UpgradeType registerCreative(String name, Component desc) {
        CreativeUpgrade type = new CreativeUpgrade(name, desc);
        UPGRADE_TYPES.put(PGHelper.id(name), type);
        return type;
    }

    private static UpgradeType registerSimple(String name, Component component, String tag) {
        UpgradeType type = new UpgradeType(name, component, tag);
        UPGRADE_TYPES.put(PGHelper.id(name), type);
        return type;
    }

    private static UpgradeType registerPreCondition(String name, Component component, String tag, String condition) {
        PreConditionUpgrade type = new PreConditionUpgrade(name, component, tag, condition);
        UPGRADE_TYPES.put(PGHelper.id(name), type);
        return type;
    }

    public static UpgradeType getFromTag(String upgradeTag) {
        return UPGRADE_TYPES.values().stream().filter(type -> type.getUpgradeTag().equals(upgradeTag)).findFirst().orElseThrow();
    }

    public static UpgradeType getFromId(String id) {
        return UPGRADE_TYPES.values().stream().filter(type -> type.getId().equals(id)).findFirst().orElseThrow();
    }
}

