/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.menu;

import com.jdolphin.ricksportalgun.common.blockentity.PortalDispenserBlockEntity;
import com.jdolphin.ricksportalgun.common.init.PGItems;
import com.jdolphin.ricksportalgun.common.init.PGMenuTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class PortalDispenserMenu
extends AbstractContainerMenu {
    private final Container dispenser;
    private final ContainerData data;
    private final ContainerLevelAccess access;

    public PortalDispenserMenu(int containerId, Inventory playerInventory) {
        this(containerId, playerInventory, (Container)new SimpleContainer(1), (ContainerData)new SimpleContainerData(2), ContainerLevelAccess.f_39287_);
    }

    public PortalDispenserMenu(int containerId, Inventory playerInventory, Container container, ContainerData data, ContainerLevelAccess access) {
        super(PGMenuTypes.PORTAL_DISPENSER, containerId);
        PortalDispenserMenu.m_38869_((Container)container, (int)1);
        PortalDispenserMenu.m_38886_((ContainerData)data, (int)2);
        this.data = data;
        this.access = access;
        this.dispenser = container;
        this.addInventoryExtendedSlots((Container)playerInventory, 8, 84);
        this.addInventoryHotbarSlots((Container)playerInventory, 8, 142);
        container.m_5856_(playerInventory.f_35978_);
        this.m_38897_(new Slot(container, 0, 26, 52){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_150930_(PGItems.PORTAL_FLUID);
            }
        });
        this.m_38884_(data);
    }

    protected void addInventoryHotbarSlots(Container container, int x, int y) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot(container, i, x + i * 18, y));
        }
    }

    protected void addInventoryExtendedSlots(Container container, int x, int y) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot(container, j + (i + 1) * 9, x + j * 18, y + i * 18));
            }
        }
    }

    public int getFuel() {
        return this.data.m_6413_(0);
    }

    public int getMaxFuel() {
        return this.data.m_6413_(1);
    }

    public void setCoords(BlockPos pos, String dim) {
        this.access.m_39292_((level, pos1) -> {
            BlockEntity entity = level.m_7702_(pos1);
            if (entity instanceof PortalDispenserBlockEntity) {
                PortalDispenserBlockEntity disp = (PortalDispenserBlockEntity)entity;
                disp.setDestination(dim, pos);
            }
        });
    }

    public boolean m_6875_(Player player) {
        return this.dispenser.m_6542_(player);
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack original = slot.m_7993_();
            itemstack = original.m_41777_();
            if (index == 0 ? !this.m_38903_(original, 1, 36, true) : !this.m_38903_(original, 0, 1, false)) {
                return ItemStack.f_41583_;
            }
            if (original.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (original.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, original);
        }
        return itemstack;
    }
}

