/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.packet.serverbound;

import com.jdolphin.ricksportalgun.common.packet.clientbound.CBOpenLocatorScreenPacket;
import com.jdolphin.ricksportalgun.common.util.helper.PGHelper;
import com.jdolphin.ricksportalgun.common.util.network.PGPayload;
import com.jdolphin.ricksportalgun.common.util.network.PGServerPayload;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public record SBOpenLocatorScreenPacket() implements PGServerPayload
{
    @Override
    public void handle(ServerPlayer player) {
        MinecraftServer server = player.f_8924_;
        server.m_201446_(() -> {
            List<String> players = Arrays.asList(server.m_7641_());
            int playerCount = server.m_7641_().length;
            ArrayList<String> biomes = new ArrayList<String>();
            ArrayList<String> structures = new ArrayList<String>();
            Optional biomeRegistry = server.m_206579_().m_254861_(Registries.f_256952_);
            Optional structureRegistry = server.m_206579_().m_254861_(Registries.f_256944_);
            int biomeCount = 0;
            int structureCount = 0;
            if (biomeRegistry.isPresent()) {
                biomeCount = ((HolderLookup.RegistryLookup)biomeRegistry.get()).m_214062_().toList().size();
                biomeRegistry.ifPresent(registry -> registry.m_255209_().forEach(holders -> {
                    String biomeName = holders.m_135782_().toString();
                    if (!biomes.contains(biomeName)) {
                        biomes.add(biomeName);
                    }
                }));
            }
            if (structureRegistry.isPresent()) {
                structureCount = ((HolderLookup.RegistryLookup)structureRegistry.get()).m_214062_().toList().size();
                structureRegistry.ifPresent(registry -> registry.m_255209_().forEach(holders -> {
                    String structureName = holders.m_135782_().toString();
                    if (!structures.contains(structureName)) {
                        structures.add(structureName);
                    }
                }));
            }
            if (playerCount == players.size() && biomeCount == biomes.size() && structureCount == structures.size()) {
                CBOpenLocatorScreenPacket packet = new CBOpenLocatorScreenPacket(players, biomes, structures);
                PGHelper.sendPacketToClient((ServerPlayer)player, (PGPayload[])new CBOpenLocatorScreenPacket[]{packet});
            }
        });
    }

    @Override
    public ResourceLocation getId() {
        return SBOpenLocatorScreenPacket.getID();
    }

    public static SBOpenLocatorScreenPacket decode(FriendlyByteBuf buf) {
        return new SBOpenLocatorScreenPacket();
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
    }

    public static ResourceLocation getID() {
        return PGHelper.id("open_locator_screen");
    }
}

