/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.client.screen.portalgun.settings;

import com.jdolphin.ricksportalgun.client.screen.AbstractBaseScreen;
import com.jdolphin.ricksportalgun.client.screen.portalgun.SettingsScreen;
import com.jdolphin.ricksportalgun.client.screen.portalgun.WaypointScreen;
import com.jdolphin.ricksportalgun.client.screen.widget.PGImageButton;
import com.jdolphin.ricksportalgun.client.screen.widget.PGItemButton;
import com.jdolphin.ricksportalgun.client.screen.widget.PGTextButton;
import com.jdolphin.ricksportalgun.client.screen.widget.ScrollableList;
import com.jdolphin.ricksportalgun.common.customization.PortalGunStyle;
import com.jdolphin.ricksportalgun.common.init.PGItems;
import com.jdolphin.ricksportalgun.common.init.PGUpgradeTypes;
import com.jdolphin.ricksportalgun.common.item.PortalGunItem;
import com.jdolphin.ricksportalgun.common.item.upgrade.UpgradeItem;
import com.jdolphin.ricksportalgun.common.item.upgrade.types.PreConditionUpgrade;
import com.jdolphin.ricksportalgun.common.item.upgrade.types.UpgradeType;
import com.jdolphin.ricksportalgun.common.packet.serverbound.SBAddUpgradePacket;
import com.jdolphin.ricksportalgun.common.util.helper.GuiHelper;
import com.jdolphin.ricksportalgun.common.util.helper.PGHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;

public class UpgradesInfoScreen
extends AbstractBaseScreen {
    private PGImageButton backButton;
    private PGImageButton addUpgrade;
    private UpgradeListWidget upgradeListWidget;
    private final List<PGItemButton> itemButtons = new ArrayList<PGItemButton>();
    private boolean showUpgradeButtons = false;

    public UpgradesInfoScreen() {
        super((Component)Component.m_237115_((String)"menu.ricksportalgun.settings.upgrades"));
    }

    protected void m_7856_() {
        super.m_7856_();
        assert (this.f_96541_ != null);
        PortalGunStyle style = this.getStyle();
        this.upgradeListWidget = (UpgradeListWidget)this.m_7787_((GuiEventListener)new UpgradeListWidget(Minecraft.m_91087_(), 170, 152, this.f_96543_ / 2 - 75, this.f_96544_ / 2 - 70, 24, style));
        this.addUpgrade = (PGImageButton)this.m_142416_((GuiEventListener)new PGImageButton(this.f_96543_ / 2 + 118, this.f_96544_ / 2 - 94, 20, 20, (Component)Component.m_237115_((String)"ricksportalgun.button.waypoint.new"), button -> {
            this.showUpgradeButtons = !this.showUpgradeButtons;
        }, 20, 20, WaypointScreen.NEW_WAYPOINT_TEXTURES));
        this.backButton = (PGImageButton)this.m_142416_((GuiEventListener)new PGImageButton(this.f_96543_ / 2 - 140, this.f_96544_ / 2 - 96, 20, 20, (Component)Component.m_237115_((String)"ricksportalgun.button.back"), button -> this.f_96541_.m_91152_((Screen)new SettingsScreen()), 20, 20, BACK_BUTTON_TEXTURE));
        this.initUpgrade(this.f_96543_ / 2 + 98, this.f_96544_ / 2 - 64);
        this.addUpgrade.setColor(style.highlightColor());
        this.addUpgrade.setRenderBackground(false);
        this.backButton.setColor(style.highlightColor());
        this.backButton.setRenderBackground(false);
        GuiHelper.setTooltip((AbstractWidget)this.backButton, (Component)Component.m_237115_((String)"ricksportalgun.button.back"));
        GuiHelper.setTooltip((AbstractWidget)this.addUpgrade, (Component)Component.m_237115_((String)"ricksportalgun.button.upgrade_new"));
    }

    private void initUpgrade(int x, int y) {
        this.itemButtons.clear();
        int i = 0;
        List<String> types = PortalGunItem.getUpgrades(this.getItemStack());
        for (UpgradeItem upgrade : PGItems.UPGRADES) {
            PreConditionUpgrade pre;
            int offsetX = x + i % 3 * 20;
            int offsetY = y + i / 3 * 20;
            LocalPlayer player = this.f_96541_.f_91074_;
            boolean hasItem = player.m_150109_().m_216874_(stack -> stack.m_41720_().equals((Object)upgrade));
            UpgradeType upgradeType = upgrade.getUpgradeType();
            boolean hasPrevious = upgradeType instanceof PreConditionUpgrade && types.contains((pre = (PreConditionUpgrade)upgradeType).getConditionTag()) || !(upgrade.getUpgradeType() instanceof PreConditionUpgrade);
            boolean hasUpgradePreviously = types.contains(upgrade.getUpgradeType().getUpgradeTag());
            boolean canApply = player.m_7500_() || hasItem && !hasUpgradePreviously && hasPrevious;
            PGItemButton button = (PGItemButton)this.m_142416_((GuiEventListener)new PGItemButton(offsetX, offsetY, 20, 20, upgrade.getUpgradeType().getName(), btn -> {
                if (canApply) {
                    SBAddUpgradePacket packet = new SBAddUpgradePacket(upgrade.getUpgradeType().getId());
                    PGHelper.sendPacketToServer(packet);
                }
            }, upgrade.m_7968_()));
            button.visible = this.showUpgradeButtons;
            button.active = canApply;
            button.setRenderBackground(false);
            this.itemButtons.add(button);
            MutableComponent desc = upgrade.getUpgradeType().getName().m_6881_();
            if (!player.m_7500_()) {
                if (!hasItem && !hasUpgradePreviously) {
                    desc.m_130946_("\n").m_7220_((Component)Component.m_237115_((String)"notice.ricksportalgun.upgrade.not_in_inventory"));
                }
                if (!hasPrevious) {
                    desc.m_130946_("\n").m_7220_((Component)Component.m_237115_((String)"notice.ricksportalgun.upgrade.needs_other"));
                }
                if (hasUpgradePreviously) {
                    desc.m_130946_("\n").m_7220_((Component)Component.m_237115_((String)"notice.ricksportalgun.upgrade.already_applied"));
                }
            }
            GuiHelper.setTooltip((AbstractWidget)button, (Component)desc);
            ++i;
        }
    }

    public void m_86600_() {
        super.m_86600_();
        ItemStack stack = this.getItemStack();
        CompoundTag tag = stack.m_41784_();
        ListTag listTag = tag.m_128437_("Upgrades", 8);
        if (this.upgradeListWidget.m_6702_().size() != listTag.size()) {
            this.m_232761_();
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        PortalGunStyle style = this.getStyle();
        graphics.m_280509_(this.f_96543_ / 2 - 154, this.f_96544_ / 2 - 110, this.f_96543_ / 2 + 165, this.f_96544_ / 2 + 100, style.bgColor());
        graphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"menu.ricksportalgun.settings.upgrades"), this.f_96543_ / 2, this.f_96544_ / 2 - 92, style.textColor());
        if (this.upgradeListWidget != null) {
            this.upgradeListWidget.m_88315_(graphics, mouseX, mouseY, partialTick);
            graphics.m_280637_(this.upgradeListWidget.getLeft(), this.upgradeListWidget.getTop(), this.upgradeListWidget.getWidth(), this.upgradeListWidget.getHeight(), style.highlightColor());
        }
        for (PGItemButton button : this.itemButtons) {
            button.visible = this.showUpgradeButtons;
            if (!button.visible) continue;
            GuiHelper.renderOutline(graphics, (AbstractWidget)button, style.highlightColor());
        }
        GuiHelper.renderOutline(graphics, (AbstractWidget)this.backButton, style.highlightColor());
        GuiHelper.renderOutline(graphics, (AbstractWidget)this.addUpgrade, style.highlightColor());
        RenderSystem.enableBlend();
        graphics.m_280163_(BG_LOCATION, this.f_96543_ / 2 - 158, this.f_96544_ / 2 - 115, 0.0f, 0.0f, 330, 224, 330, 224);
        RenderSystem.disableBlend();
        Style guiStyle = GuiHelper.getStyle(mouseX, mouseY);
        if (guiStyle != null && guiStyle.m_131186_() != null) {
            this.m_280264_(graphics, mouseX, mouseY, partialTick);
        }
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
    }

    public static class UpgradeListWidget
    extends ScrollableList<UpgradeEntry> {
        private final PortalGunStyle style;

        public UpgradeListWidget(Minecraft minecraft, int width, int height, int x0, int pY0, int pItemHeight, PortalGunStyle style) {
            super(minecraft, width, height, x0, pY0, pItemHeight);
            assert (minecraft.f_91074_ != null);
            this.style = style;
            this.refreshEntries(minecraft.f_91074_.m_21120_(PGHelper.getPortalGunHand((Player)minecraft.f_91074_)));
            this.setRenderScrollbar(false);
        }

        public void refreshEntries(ItemStack stack) {
            this.m_6702_().clear();
            List<String> upgrades = PortalGunItem.getUpgrades(stack);
            for (String upgrade : upgrades) {
                if (upgrade != null) {
                    this.addEntry(new UpgradeEntry(PGUpgradeTypes.getFromTag(upgrade), this, this.style.highlightColor()));
                    continue;
                }
                LogManager.getLogger().warn("Failed to get upgrade");
            }
        }

        @Override
        public void m_88315_(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
            super.m_88315_(graphics, pMouseX, pMouseY, pPartialTick);
            if (this.m_6702_().isEmpty()) {
                graphics.m_280653_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"notice.ricksportalgun.no_upgrades"), this.x0 + this.width / 2, this.y0 + this.height / 2, this.style.textColor());
            }
        }

        public void m_142291_(NarrationElementOutput narrationElementOutput) {
        }

        public static class UpgradeEntry
        extends ScrollableList.Entry<UpgradeEntry> {
            UpgradeType type;
            protected UpgradeListWidget list;
            private final PGTextButton button;
            private final int color;

            public UpgradeEntry(UpgradeType type, UpgradeListWidget widget, int color) {
                this.type = type;
                this.list = widget;
                this.color = color;
                this.button = new PGTextButton(16, 0, 152, 20, type.getName(), button1 -> {}, Minecraft.m_91087_().f_91062_);
                GuiHelper.setTooltip((AbstractWidget)this.button, type.getDescription());
            }

            @Override
            public void render(GuiGraphics graphics, int pIndex, int pTop, int pLeft, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean pIsMouseOver, float pPartialTick) {
                if (pTop > this.list.headerHeight) {
                    this.button.m_252865_(pLeft - 24);
                    this.button.m_253211_(pTop);
                    this.button.m_88315_(graphics, pMouseX, pMouseY, pPartialTick);
                    GuiHelper.renderOutline(graphics, (AbstractWidget)this.button, this.color);
                }
            }

            public List<? extends GuiEventListener> m_6702_() {
                return List.of();
            }
        }
    }
}

