/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.packet.serverbound;

import com.jdolphin.ricksportalgun.common.item.PortalGunItem;
import com.jdolphin.ricksportalgun.common.util.helper.LevelHelper;
import com.jdolphin.ricksportalgun.common.util.helper.PGConfigHelper;
import com.jdolphin.ricksportalgun.common.util.helper.PGHelper;
import com.jdolphin.ricksportalgun.common.util.network.PGServerPayload;
import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public record SBLocatePacket(String name, int value) implements PGServerPayload
{
    @Override
    public void handle(ServerPlayer player) {
        MinecraftServer server = player.f_8924_;
        server.m_201446_(() -> {
            ResourceLocation location;
            ServerLevel level = player.m_284548_();
            ItemStack stack = player.m_21120_(PGHelper.getPortalGunHand((Player)player));
            if (this.value == 0) {
                if (PGConfigHelper.disableBiomeLocating()) {
                    PGHelper.sendFailMsg((Player)player, Component.m_237115_((String)"error.ricksportalgun.locating.biome.disabled"));
                    return;
                }
                Optional optionalRegistry = server.m_206579_().m_254861_(Registries.f_256952_);
                if (optionalRegistry.isPresent()) {
                    location = new ResourceLocation(this.name);
                    Pair pair = level.m_215069_(biomeHolder -> biomeHolder.m_203373_(location), player.m_20183_(), 6400, 32, 64);
                    if (pair != null) {
                        BlockPos pos = (BlockPos)pair.getFirst();
                        BlockPos safePos = LevelHelper.getSafePos(pos, level);
                        PortalGunItem.setHopLocation(stack, LevelHelper.getPlayerDimensionLocation((Player)player), safePos);
                        PGHelper.sendSuccessMsg((Player)player, PGHelper.COORDS_SET);
                    } else {
                        PGHelper.sendFailMsg((Player)player, Component.m_237110_((String)"error.ricksportalgun.locating.biome.not_in_area", (Object[])new Object[]{this.name}));
                    }
                }
            }
            if (this.value == 1) {
                if (PGConfigHelper.disablePlayerLocating()) {
                    PGHelper.sendFailMsg((Player)player, Component.m_237115_((String)"error.ricksportalgun.locating.player.disabled"));
                    return;
                }
                ServerPlayer targetPlayer = server.m_6846_().m_11255_(this.name);
                if (targetPlayer != null) {
                    Vec3 targetVec = Vec3.m_82503_((Vec2)new Vec2(45.0f, targetPlayer.m_146908_() + 180.0f));
                    BlockPos pos = targetPlayer.m_20183_().m_7494_();
                    BlockPos betterPos = BlockPos.m_274561_((double)((double)pos.m_123341_() + targetVec.f_82479_ * 2.0), (double)pos.m_123342_(), (double)((double)pos.m_123343_() + targetVec.f_82481_ * 2.0));
                    PortalGunItem.setHopLocation(stack, LevelHelper.getPlayerDimensionLocation((Player)targetPlayer), betterPos);
                    PGHelper.sendSuccessMsg((Player)player, PGHelper.COORDS_SET);
                } else {
                    PGHelper.sendFailMsg((Player)player, Component.m_237110_((String)"error.ricksportalgun.locating.player.not_found", (Object[])new Object[]{this.name}));
                }
            }
            if (this.value == 2) {
                if (PGConfigHelper.disableStructureLocating()) {
                    PGHelper.sendFailMsg((Player)player, Component.m_237115_((String)"error.ricksportalgun.locating.structure.disabled"));
                    return;
                }
                Registry registry = server.m_206579_().m_175515_(Registries.f_256944_);
                Structure structure = (Structure)registry.m_6246_(ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)(location = new ResourceLocation(this.name))));
                if (structure != null) {
                    HolderSet.Direct set = HolderSet.m_205809_((Holder[])new Holder[]{Holder.m_205709_((Object)structure)});
                    Pair pair = level.m_7726_().m_8481_().m_223037_(level, (HolderSet)set, player.m_20183_(), 256, false);
                    if (pair != null) {
                        BlockPos pos = (BlockPos)pair.getFirst();
                        BlockPos safePos = LevelHelper.getSafePos(pos, level);
                        PortalGunItem.setHopLocation(stack, LevelHelper.getPlayerDimensionLocation((Player)player), safePos);
                        PGHelper.sendSuccessMsg((Player)player, PGHelper.COORDS_SET);
                    } else {
                        PGHelper.sendFailMsg((Player)player, Component.m_237110_((String)"error.ricksportalgun.locating.structure.not_in_area", (Object[])new Object[]{this.name}));
                    }
                } else {
                    PGHelper.sendFailMsg((Player)player, Component.m_237110_((String)"error.ricksportalgun.locating.structure.unknown", (Object[])new Object[]{this.name}));
                }
            }
        });
    }

    @Override
    public ResourceLocation getId() {
        return SBLocatePacket.getID();
    }

    public static SBLocatePacket decode(FriendlyByteBuf buf) {
        String name = buf.m_130277_();
        int value = buf.readInt();
        return new SBLocatePacket(name, value);
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130070_(this.name);
        buf.writeInt(this.value);
    }

    public static ResourceLocation getID() {
        return PGHelper.id("locate");
    }
}

