/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.packet.serverbound;

import com.jdolphin.ricksportalgun.common.item.IWaypointStorage;
import com.jdolphin.ricksportalgun.common.util.Waypoint;
import com.jdolphin.ricksportalgun.common.util.helper.PGHelper;
import com.jdolphin.ricksportalgun.common.util.network.PGServerPayload;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public record SBManageWaypointsPacket(String waypoint, boolean remove) implements PGServerPayload
{
    @Override
    public void handle(ServerPlayer player) {
        MinecraftServer server = player.f_8924_;
        server.m_201446_(() -> {
            ItemStack stack = player.m_21120_(PGHelper.getPortalGunHand((Player)player));
            Waypoint wp = Waypoint.getWaypoint(this.waypoint);
            if (stack.m_41720_() instanceof IWaypointStorage && wp != null) {
                if (!this.remove) {
                    IWaypointStorage.addWaypoint(stack, wp);
                }
                if (this.remove) {
                    IWaypointStorage.deleteWaypoint(stack, wp);
                    PGHelper.sendSuccessMsg((Player)player, Component.m_237110_((String)"ricksportalgun.deleted", (Object[])new Object[]{wp.getName()}));
                }
            }
        });
    }

    @Override
    public ResourceLocation getId() {
        return SBManageWaypointsPacket.getID();
    }

    public static SBManageWaypointsPacket decode(FriendlyByteBuf buf) {
        String wp = buf.m_130277_();
        boolean delete = buf.readBoolean();
        return new SBManageWaypointsPacket(wp, delete);
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130070_(this.waypoint);
        buf.writeBoolean(this.remove);
    }

    public static ResourceLocation getID() {
        return PGHelper.id("manage_waypoint");
    }
}

