/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.util.helper;

import java.awt.Color;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;

public class GuiHelper {
    public static int opaqueColor(int color) {
        return color | 0xFF000000;
    }

    public static void renderWidgets(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick, AbstractWidget ... widgets) {
        for (AbstractWidget widget : widgets) {
            if (widget == null) continue;
            widget.m_88315_(graphics, pMouseX, pMouseY, pPartialTick);
        }
    }

    public static void drawWordWrap(GuiGraphics graphics, Font font, FormattedText text, int x, int y, int lineWidth, int color) {
        for (FormattedCharSequence formattedcharsequence : font.m_92923_(text, lineWidth)) {
            graphics.m_280364_(font, formattedcharsequence, x, y, color);
            y += 9;
        }
    }

    public static void renderScrollingString(GuiGraphics guiGraphics, Component text, int minX, int minY, int maxX, int maxY, int color) {
        GuiHelper.renderScrollingString(guiGraphics, text, (minX + maxX) / 2, minX, minY, maxX, maxY, color);
    }

    public static void renderScrollingString(GuiGraphics guiGraphics, Component text, int centerX, int minX, int minY, int maxX, int maxY, int color) {
        Font font = Minecraft.m_91087_().f_91062_;
        int i = font.m_92852_((FormattedText)text);
        int j = (minY + maxY - 9) / 2 + 1;
        int k = maxX - minX;
        if (i > k) {
            int l = i - k;
            double d0 = (double)Util.m_137550_() / 1000.0;
            double d1 = Math.max((double)l * 0.5, 3.0);
            double d2 = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * d0 / d1)) / 2.0 + 0.5;
            double d3 = Mth.m_14139_((double)d2, (double)0.0, (double)l);
            guiGraphics.m_280588_(minX, minY, maxX, maxY);
            guiGraphics.m_280430_(font, text, minX - (int)d3, j, color);
            guiGraphics.m_280618_();
        } else {
            int i1 = Mth.m_14045_((int)centerX, (int)(minX + i / 2), (int)(maxX - i / 2));
            guiGraphics.m_280653_(font, text, i1, j, color);
        }
    }

    public static void drawWhiteString(GuiGraphics graphics, String text, int x, int y) {
        graphics.m_280430_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237113_((String)text), x, y, Color.WHITE.getRGB());
    }

    public static void drawWhiteString(GuiGraphics graphics, Component text, int x, int y) {
        graphics.m_280430_(Minecraft.m_91087_().f_91062_, text, x, y, Color.WHITE.getRGB());
    }

    public static void drawWhiteCenteredString(GuiGraphics graphics, Component text, int x, int y) {
        GuiHelper.drawWhiteCenteredString(graphics, text.getString(), x, y);
    }

    public static void drawWhiteCenteredString(GuiGraphics graphics, String text, int x, int y) {
        graphics.m_280137_(Minecraft.m_91087_().f_91062_, text, x, y, Color.WHITE.getRGB());
    }

    public static void renderOutline(GuiGraphics graphics, AbstractWidget widget, int color) {
        if (widget != null) {
            graphics.m_280637_(widget.m_252754_(), widget.m_252907_(), widget.m_5711_(), widget.m_93694_(), color);
        }
    }

    public static void setTooltip(AbstractWidget widget, Component component) {
        if (widget != null && component != null) {
            Tooltip tooltip = Tooltip.m_257550_((Component)component);
            widget.m_257544_(tooltip);
        }
    }

    public static void renderTooltip(GuiGraphics graphics, Component component, AbstractWidget widget) {
        if (widget.m_274382_()) {
            graphics.m_280557_(Minecraft.m_91087_().f_91062_, component, widget.m_252754_(), widget.m_252907_());
        }
    }

    public static Style getStyle(int x, int y) {
        return Minecraft.m_91087_().f_91065_.m_93076_().m_93800_((double)x, (double)y);
    }
}

