/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.util.helper;

import com.google.common.collect.Lists;
import com.jdolphin.ricksportalgun.PGConstants;
import com.jdolphin.ricksportalgun.common.init.PGTags;
import com.jdolphin.ricksportalgun.common.item.upgrade.types.UpgradeType;
import com.jdolphin.ricksportalgun.common.util.network.PGPayload;
import com.jdolphin.ricksportalgun.common.util.network.PGServerPayload;
import com.jdolphin.ricksportalgun.common.util.platform.PGServices;
import java.awt.Color;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;

public class PGHelper {
    public static MutableComponent COORDS_SET = Component.m_237115_((String)"notice.ricksportalgun.destination.set");

    public static ResourceLocation id(String string) {
        return new ResourceLocation("ricksportalgun", string);
    }

    public static ResourceLocation vanilla(String string) {
        return new ResourceLocation("minecraft", string);
    }

    public static boolean checkTagBoolean(CompoundTag tag, String key) {
        return tag.m_128441_(key) && tag.m_128471_(key);
    }

    public static boolean hasUpgrade(CompoundTag tag, UpgradeType type) {
        ListTag listTag = tag.m_128437_("Upgrades", 8);
        return listTag.contains((Object)StringTag.m_129297_((String)type.getUpgradeTag()));
    }

    public static int seconds(int amount) {
        return 20 * amount;
    }

    public static int minutes(int amount) {
        return 60 * PGHelper.seconds(amount);
    }

    public static int getTextureDiffuseColor(DyeItem dyeItem) {
        float[] rgb = dyeItem.m_41089_().m_41068_();
        float r = rgb[0];
        float g = rgb[1];
        float b = rgb[2];
        return new Color(r, g, b).getRGB();
    }

    public static boolean canPlayerAccessGun(Player player, ItemStack stack) {
        String uuid;
        CompoundTag tag = stack.m_41784_();
        boolean locked = tag.m_128441_("Lock") && tag.m_128471_("Lock");
        String string = uuid = tag.m_128441_("Owner") ? tag.m_128342_("Owner").toString() : "";
        if (locked) {
            return uuid.isEmpty() || player.m_20149_().equals(uuid);
        }
        return true;
    }

    public static String getEntityAsString(EntityType<?> type) {
        ResourceLocation rl = BuiltInRegistries.f_256780_.m_7981_(type);
        return rl.toString();
    }

    public static InteractionHand getPortalGunHand(Player player) {
        if (player.m_21205_().m_204117_(PGTags.Items.PORTAL_GUNS)) {
            return InteractionHand.MAIN_HAND;
        }
        return InteractionHand.OFF_HAND;
    }

    public static InteractionHand getOppositeHand(InteractionHand hand) {
        return hand.equals((Object)InteractionHand.MAIN_HAND) ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
    }

    public static List<String> defaultDisabledEntities() {
        return Lists.newArrayList((Object[])new String[]{"minecraft:ender_dragon", "minecraft:wither", "minecraft:warden", "ricksportalgun:portal"});
    }

    public static void sendSuccessMsg(Player player, String msg) {
        PGHelper.sendSuccessMsg(player, Component.m_237115_((String)msg));
    }

    public static void sendSuccessMsg(Player player, MutableComponent msg) {
        player.m_5661_((Component)msg.m_130940_(ChatFormatting.GREEN), false);
    }

    public static void sendFailMsg(Player player, MutableComponent msg) {
        player.m_5661_((Component)msg.m_130940_(ChatFormatting.RED), false);
    }

    public static void sendFailMsg(Player player, String msg) {
        PGHelper.sendFailMsg(player, Component.m_237115_((String)msg));
    }

    public static <P extends PGServerPayload> void sendPacketToServer(P packet) {
        PGServices.PLATFORM.sendPacketToServer(packet);
    }

    public static <P extends PGPayload> void sendPacketToClient(ServerPlayer player, P ... packet) {
        PGServices.PLATFORM.sendPacketToClient(player, (PGPayload[])packet);
    }

    public static <T> T getRandomFromList(List<T> list) {
        int i = list.size();
        int index = PGConstants.RANDOM.nextInt(i);
        return list.get(index);
    }
}

