/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun;

import com.jdolphin.ricksportalgun.RicksPortalGunCommonMain;
import com.jdolphin.ricksportalgun.common.config.PGClientConfig;
import com.jdolphin.ricksportalgun.common.config.PGCommonConfig;
import com.jdolphin.ricksportalgun.common.init.ForgePackets;
import com.jdolphin.ricksportalgun.common.init.PGBlockEntities;
import com.jdolphin.ricksportalgun.common.init.PGBlocks;
import com.jdolphin.ricksportalgun.common.init.PGEntities;
import com.jdolphin.ricksportalgun.common.init.PGItems;
import com.jdolphin.ricksportalgun.common.init.PGMenuTypes;
import com.jdolphin.ricksportalgun.common.init.PGRecipeSerializers;
import com.jdolphin.ricksportalgun.common.init.PGRecipeTypes;
import com.jdolphin.ricksportalgun.common.packet.clientbound.CBSyncDimensionListPacket;
import com.jdolphin.ricksportalgun.common.util.helper.LevelHelper;
import com.jdolphin.ricksportalgun.common.util.helper.PGConfigHelper;
import com.jdolphin.ricksportalgun.common.util.helper.PGHelper;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="ricksportalgun")
public class RicksPortalGunForgeMain {
    public RicksPortalGunForgeMain(FMLJavaModLoadingContext context) {
        IEventBus bus = context.getModEventBus();
        RicksPortalGunCommonMain.init();
        MinecraftForge.EVENT_BUS.addListener(this::onPlayerJoin);
        bus.addListener(this::commonSetup);
        bus.addListener(this::buildContents);
        RicksPortalGunForgeMain.bind(bus, Registries.f_256747_, PGBlocks::init);
        RicksPortalGunForgeMain.bind(bus, Registries.f_256913_, PGItems::init);
        RicksPortalGunForgeMain.bind(bus, Registries.f_256922_, PGBlockEntities::init);
        RicksPortalGunForgeMain.bind(bus, Registries.f_256939_, PGEntities::init);
        RicksPortalGunForgeMain.bind(bus, Registries.f_256798_, PGMenuTypes::init);
        RicksPortalGunForgeMain.bind(bus, Registries.f_256954_, PGRecipeTypes::init);
        RicksPortalGunForgeMain.bind(bus, Registries.f_256764_, PGRecipeSerializers::init);
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)PGCommonConfig.SPEC, "ricksportalgun-common.toml");
        context.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)PGClientConfig.SPEC, "ricksportalgun-client.toml");
    }

    private void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer serverPlayer;
        MinecraftServer server;
        Player player = event.getEntity();
        if (player instanceof ServerPlayer && (server = (serverPlayer = (ServerPlayer)player).m_20194_()) != null) {
            ArrayList<String> dims = new ArrayList<String>(LevelHelper.getDimensionsAsString(server.m_129785_()).stream().filter(s -> !PGConfigHelper.getDisabledDimensions().contains(s)).toList());
            if (!dims.contains(PGHelper.id("blender").toString()) && !PGConfigHelper.getDisabledDimensions().contains(PGHelper.id("blender").toString())) {
                dims.add(PGHelper.id("blender").toString());
            }
            CBSyncDimensionListPacket dimSync = new CBSyncDimensionListPacket(dims);
            ForgePackets.sendToPlayer(serverPlayer, dimSync);
        }
    }

    private static <T> void bind(IEventBus bus, ResourceKey<Registry<T>> registry, Consumer<BiConsumer<T, ResourceLocation>> source) {
        bus.addListener(event -> {
            if (registry.equals((Object)event.getRegistryKey())) {
                source.accept((t, rl) -> event.register(registry, rl, () -> t));
            }
        });
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(ForgePackets::init);
    }

    public void buildContents(BuildCreativeModeTabContentsEvent event) {
        ResourceKey key = event.getTabKey();
        for (Map.Entry<Item, ResourceKey<CreativeModeTab>> entry : PGItems.TABS.entrySet()) {
            ResourceKey<CreativeModeTab> entryKey = entry.getValue();
            if (!key.equals(entryKey)) continue;
            event.m_246326_((ItemLike)entry.getKey());
        }
    }
}

