/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.client.screen.widget;

import com.google.common.collect.ImmutableList;
import com.jdolphin.ricksportalgun.common.util.helper.PGHelper;
import java.util.Collection;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;

public class PGCycleButton<T>
extends AbstractButton {
    private static final List<Boolean> BOOLEAN_OPTIONS;
    public static ResourceLocation ARROW_TEXTURES;
    private int index;
    private T value;
    private final ValueListSupplier<T> values;
    private final Function<T, Component> valueStringifier;
    private final Function<PGCycleButton<T>, MutableComponent> narrationProvider;
    private final OnValueChange<T> onValueChange;
    private final OptionInstance.TooltipSupplier<T> tooltipSupplier;
    private boolean renderBG = true;
    private boolean renderArrows = false;
    private int color = this.f_93623_ ? 0xFFFFFF : 0xA0A0A0 | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24;

    PGCycleButton(int x, int y, int width, int height, Component message, int index, T value, ValueListSupplier<T> values, Function<T, Component> valueStringifier, Function<PGCycleButton<T>, MutableComponent> narrationProvider, OnValueChange<T> onValueChange, OptionInstance.TooltipSupplier<T> tooltipSupplier) {
        super(x, y, width, height, message);
        this.index = index;
        this.value = value;
        this.values = values;
        this.valueStringifier = valueStringifier;
        this.narrationProvider = narrationProvider;
        this.onValueChange = onValueChange;
        this.tooltipSupplier = tooltipSupplier;
        this.m_257936_();
    }

    public void setRenderBackground(boolean renderBG) {
        this.renderBG = renderBG;
    }

    public void setRenderArrows(boolean renderArrows) {
        this.renderArrows = renderArrows;
    }

    public void setTextColor(int color) {
        this.color = color;
    }

    public int getTextColor() {
        return this.color;
    }

    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        if (this.renderBG) {
            super.m_87963_(graphics, mouseX, mouseY, delta);
        }
        if (this.renderArrows) {
            float r = (float)FastColor.ARGB32.m_13665_((int)this.color) / 255.0f;
            float g = (float)FastColor.ARGB32.m_13667_((int)this.color) / 255.0f;
            float b = (float)FastColor.ARGB32.m_13669_((int)this.color) / 255.0f;
            float a = (float)FastColor.ARGB32.m_13655_((int)this.color) / 255.0f;
            graphics.m_280246_(r, g, b, a);
            graphics.m_280411_(ARROW_TEXTURES, this.m_252754_() + 1, this.m_252907_() + this.f_93619_ - 18, 16, 16, 0.0f, 0.0f, 16, 16, 32, 16);
            graphics.m_280411_(ARROW_TEXTURES, this.m_252754_() + this.f_93618_ - 17, this.m_252907_() + this.f_93619_ - 18, 16, 16, 16.0f, 0.0f, 16, 16, 32, 16);
            graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        }
        Component component = this.m_274382_() ? ComponentUtils.m_130750_((MutableComponent)this.m_6035_().m_6881_(), (Style)Style.f_131099_.m_131162_(Boolean.valueOf(true))) : this.m_6035_();
        PGCycleButton.m_280138_((GuiGraphics)graphics, (Font)Minecraft.m_91087_().f_91062_, (Component)component, (int)this.m_252754_(), (int)this.m_252907_(), (int)(this.m_252754_() + this.m_5711_()), (int)(this.m_252907_() + this.m_93694_()), (int)this.color);
    }

    private void m_257936_() {
        this.m_257544_(this.tooltipSupplier.m_257630_(this.value));
    }

    public void m_5691_() {
        if (Screen.m_96638_()) {
            this.cycleValue(-1);
        } else {
            this.cycleValue(1);
        }
    }

    private void cycleValue(int delta) {
        List<T> list = this.values.getSelectedList();
        this.index = Mth.m_14100_((int)(this.index + delta), (int)list.size());
        T t = list.get(this.index);
        this.updateValue(t);
        this.onValueChange.onValueChange(this, t);
    }

    private T getCycledValue(int delta) {
        List<T> list = this.values.getSelectedList();
        return list.get(Mth.m_14100_((int)(this.index + delta), (int)list.size()));
    }

    public boolean mouseScrolled(double p_168885_, double p_168886_, double p_168887_, double p_294881_) {
        if (p_294881_ > 0.0) {
            this.cycleValue(-1);
        } else if (p_294881_ < 0.0) {
            this.cycleValue(1);
        }
        return true;
    }

    private void updateValue(T value) {
        Component component = this.createLabelForValue(value);
        this.m_93666_(component);
        this.value = value;
        this.m_257936_();
    }

    private Component createLabelForValue(T value) {
        return this.valueStringifier.apply(value);
    }

    public T getValue() {
        return this.value;
    }

    protected MutableComponent m_5646_() {
        return this.narrationProvider.apply(this);
    }

    public void m_168797_(NarrationElementOutput p_168889_) {
        p_168889_.m_169146_(NarratedElementType.TITLE, (Component)this.m_5646_());
        if (this.f_93623_) {
            T t = this.getCycledValue(1);
            Component component = this.createLabelForValue(t);
            if (this.m_93696_()) {
                p_168889_.m_169146_(NarratedElementType.USAGE, (Component)Component.m_237110_((String)"narration.cycle_button.usage.focused", (Object[])new Object[]{component}));
            } else {
                p_168889_.m_169146_(NarratedElementType.USAGE, (Component)Component.m_237110_((String)"narration.cycle_button.usage.hovered", (Object[])new Object[]{component}));
            }
        }
    }

    public MutableComponent createDefaultNarrationMessage() {
        return PGCycleButton.m_168799_((Component)this.m_6035_());
    }

    public static <T> Builder<T> builder(Function<T, Component> valueStringifier) {
        return new Builder<T>(valueStringifier);
    }

    public static Builder<Boolean> booleanBuilder(Component componentOn, Component componentOff) {
        return new Builder<Boolean>(b -> b != false ? componentOn : componentOff).withValues((Collection<Boolean>)BOOLEAN_OPTIONS);
    }

    static {
        ARROW_TEXTURES = PGHelper.id("textures/gui/sprites/icon/arrow.png");
        BOOLEAN_OPTIONS = ImmutableList.of((Object)Boolean.TRUE, (Object)Boolean.FALSE);
    }

    public static interface ValueListSupplier<T> {
        public List<T> getSelectedList();

        public List<T> getDefaultList();

        public static <T> ValueListSupplier<T> create(Collection<T> values) {
            ImmutableList list = ImmutableList.copyOf(values);
            return new ValueListSupplier<T>((List)list){
                final /* synthetic */ List val$list;
                {
                    this.val$list = list;
                }

                @Override
                public List<T> getSelectedList() {
                    return this.val$list;
                }

                @Override
                public List<T> getDefaultList() {
                    return this.val$list;
                }
            };
        }

        public static <T> ValueListSupplier<T> create(final BooleanSupplier altListSelector, List<T> defaultList, List<T> selectedList) {
            ImmutableList list = ImmutableList.copyOf(defaultList);
            ImmutableList list1 = ImmutableList.copyOf(selectedList);
            return new ValueListSupplier<T>(){
                final /* synthetic */ List val$list1;
                final /* synthetic */ List val$list;
                {
                    this.val$list1 = list;
                    this.val$list = list2;
                }

                @Override
                public List<T> getSelectedList() {
                    return altListSelector.getAsBoolean() ? this.val$list1 : this.val$list;
                }

                @Override
                public List<T> getDefaultList() {
                    return this.val$list;
                }
            };
        }
    }

    public static interface OnValueChange<T> {
        public void onValueChange(PGCycleButton<T> var1, T var2);
    }

    public static class Builder<T> {
        private int initialIndex;
        private T initialValue;
        private final Function<T, Component> valueStringifier;
        private OptionInstance.TooltipSupplier<T> tooltipSupplier = p_168964_ -> null;
        private Function<PGCycleButton<T>, MutableComponent> narrationProvider = PGCycleButton::createDefaultNarrationMessage;
        private ValueListSupplier<T> values = ValueListSupplier.create(ImmutableList.of());

        public Builder(Function<T, Component> valueStringifier) {
            this.valueStringifier = valueStringifier;
        }

        public Builder<T> withValues(Collection<T> values) {
            return this.withValues(ValueListSupplier.create(values));
        }

        @SafeVarargs
        public final Builder<T> withValues(T ... values) {
            return this.withValues((Collection<T>)ImmutableList.copyOf((Object[])values));
        }

        public Builder<T> withValues(ValueListSupplier<T> values) {
            this.values = values;
            return this;
        }

        public Builder<T> withInitialValue(T initialValue) {
            this.initialValue = initialValue;
            int i = this.values.getDefaultList().indexOf(initialValue);
            if (i != -1) {
                this.initialIndex = i;
            }
            return this;
        }

        public PGCycleButton<T> create(Component message, OnValueChange<T> onValueChange) {
            return this.create(0, 0, 150, 20, message, onValueChange);
        }

        public PGCycleButton<T> create(int x, int y, int width, int height, Component name) {
            return this.create(x, y, width, height, name, (p_168946_, p_168947_) -> {});
        }

        public PGCycleButton<T> create(int x, int y, int width, int height, Component name, OnValueChange<T> onValueChange) {
            List<T> list = this.values.getDefaultList();
            if (list.isEmpty()) {
                throw new IllegalStateException("No values for cycle button");
            }
            T t = this.initialValue != null ? this.initialValue : list.get(this.initialIndex);
            Component component = this.valueStringifier.apply(t);
            return new PGCycleButton<T>(x, y, width, height, component, this.initialIndex, t, this.values, this.valueStringifier, this.narrationProvider, onValueChange, this.tooltipSupplier);
        }
    }
}

