/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.client.screen.workbench;

import com.jdolphin.ricksportalgun.client.screen.widget.PGItemButton;
import com.jdolphin.ricksportalgun.client.screen.widget.ScrollableList;
import com.jdolphin.ricksportalgun.client.screen.widget.WaypointListWidget;
import com.jdolphin.ricksportalgun.client.screen.workbench.AbstractWorkbenchScreen;
import com.jdolphin.ricksportalgun.common.init.PGItems;
import com.jdolphin.ricksportalgun.common.init.PGTags;
import com.jdolphin.ricksportalgun.common.menu.workbench.WaypointTransferMenu;
import com.jdolphin.ricksportalgun.common.packet.serverbound.SBWorkbenchWaypointEditPackage;
import com.jdolphin.ricksportalgun.common.util.Waypoint;
import com.jdolphin.ricksportalgun.common.util.helper.GuiHelper;
import com.jdolphin.ricksportalgun.common.util.helper.PGHelper;
import java.awt.Color;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import oshi.util.tuples.Pair;

public class WaypointTransferScreen
extends AbstractWorkbenchScreen<WaypointTransferMenu> {
    public static final ResourceLocation BG = PGHelper.id("textures/gui/workbench/waypoint_transfer.png");
    public static final ResourceLocation WP_INFO_BG = PGHelper.id("textures/gui/workbench/waypoint_info_bg.png");
    private WaypointListWidget leftWaypointList;
    private WaypointListWidget rightWaypointList;
    private Pair<Waypoint, Side> selectedWaypoint;
    private Button copy;
    private Button moveTo;
    private Button delete;

    public WaypointTransferScreen(WaypointTransferMenu menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
        this.f_97727_ = 211;
        this.f_97726_ = 212;
        this.f_97730_ = this.f_97726_ - 188;
        this.f_97731_ = this.f_97727_ - 93;
        this.f_97728_ = this.f_97726_ - 193;
        this.f_97729_ = this.f_97727_ - 207;
    }

    public boolean m_6050_(double d, double d1, double d2) {
        Object t;
        Optional optional = this.m_94729_(d, d1);
        if (optional.isPresent() && (t = optional.get()) instanceof ScrollableList) {
            ScrollableList list = (ScrollableList)((Object)t);
            return list.m_6050_(d, d1, d2);
        }
        return super.m_6050_(d, d1, d2);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        Optional optional = this.m_94729_(mouseX, mouseY);
        if (optional.isEmpty()) {
            this.leftWaypointList.m_93692_(false);
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void m_7856_() {
        super.m_7856_();
        this.leftWaypointList = (WaypointListWidget)this.m_142416_((GuiEventListener)new WaypointListWidget(73, 100, this.f_96543_ / 2 - 86, this.f_96544_ / 2 - 93, 16, this.getTopSlotItem(), false, 70, 16));
        this.leftWaypointList.setRenderScrollbar(false);
        this.rightWaypointList = (WaypointListWidget)this.m_142416_((GuiEventListener)new WaypointListWidget(73, 100, this.f_96543_ / 2 + 13, this.f_96544_ / 2 - 93, 16, this.getBottomSlotItem(), false, 70, 16));
        this.rightWaypointList.setRenderScrollbar(false);
        Button.OnPress onPress = button -> {
            WaypointListWidget widget;
            WaypointListWidget.WaypointEntry entry;
            GuiEventListener listener;
            Optional optional = this.m_94729_(button.m_252754_(), button.m_252907_());
            if (optional.isPresent() && (listener = (GuiEventListener)optional.get()) instanceof WaypointListWidget && (entry = (WaypointListWidget.WaypointEntry)(widget = (WaypointListWidget)listener).getEntryAtPosition(button.m_252754_(), button.m_252907_())) != null) {
                Side side = ((Object)((Object)widget)).equals((Object)this.leftWaypointList) ? Side.LEFT : Side.RIGHT;
                this.selectedWaypoint = new Pair((Object)entry.waypoint, (Object)side);
            }
        };
        this.leftWaypointList.setOnPress(onPress);
        this.rightWaypointList.setOnPress(onPress);
        this.copy = (Button)this.m_7787_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"ricksportalgun.button.workbench.copy"), button -> {
            if (this.selectedWaypoint != null) {
                Waypoint wp = (Waypoint)this.selectedWaypoint.getA();
                this.sendPacket(wp, true, false);
            }
        }).m_252987_(this.f_96543_ / 2 - 175, this.f_96544_ / 2 - 10, 80, 16).m_253136_());
        this.moveTo = (Button)this.m_7787_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"ricksportalgun.button.workbench.move"), button -> {
            if (this.selectedWaypoint != null) {
                Waypoint wp = (Waypoint)this.selectedWaypoint.getA();
                this.sendPacket(wp, false, false);
                this.selectedWaypoint = null;
            }
        }).m_252987_(this.f_96543_ / 2 - 175, this.f_96544_ / 2 + 8, 80, 16).m_253136_());
        this.delete = (Button)this.m_7787_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"ricksportalgun.button.delete"), button -> {
            if (this.selectedWaypoint != null) {
                Waypoint wp = (Waypoint)this.selectedWaypoint.getA();
                this.sendPacket(wp, false, true);
                this.selectedWaypoint = null;
            }
        }).m_252987_(this.f_96543_ / 2 - 175, this.f_96544_ / 2 + 26, 80, 16).m_253136_());
        PGItemButton skin = (PGItemButton)this.m_142416_((GuiEventListener)new PGItemButton(this.f_96543_ / 2 + 91, this.f_96544_ / 2 - 105, 24, 24, (Component)Component.m_237115_((String)"menu.ricksportalgun.workbench.skin"), button -> this.setScreen(1), PGItems.PORTAL_GUN.m_7968_()));
        skin.setRenderBackground(false);
        PGItemButton waypoint = (PGItemButton)this.m_142416_((GuiEventListener)new PGItemButton(this.f_96543_ / 2 + 91, this.f_96544_ / 2 - 80, 24, 24, (Component)Component.m_237115_((String)"menu.ricksportalgun.workbench.waypoint"), button -> {}, PGItems.DATA_CARD.m_7968_()));
        waypoint.setRenderBackground(false);
        PGItemButton craft = (PGItemButton)this.m_142416_((GuiEventListener)new PGItemButton(this.f_96543_ / 2 + 91, this.f_96544_ / 2 - 55, 24, 24, (Component)Component.m_237115_((String)"menu.ricksportalgun.workbench.craft"), button -> this.setScreen(2), Items.f_41960_.m_7968_()));
        craft.setRenderBackground(false);
        GuiHelper.setTooltip((AbstractWidget)skin, (Component)Component.m_237115_((String)"menu.ricksportalgun.workbench.skin"));
        GuiHelper.setTooltip((AbstractWidget)waypoint, (Component)Component.m_237115_((String)"menu.ricksportalgun.workbench.waypoint"));
        GuiHelper.setTooltip((AbstractWidget)craft, (Component)Component.m_237115_((String)"menu.ricksportalgun.workbench.craft"));
        GuiHelper.setTooltip((AbstractWidget)this.copy, (Component)Component.m_237115_((String)"tooltip.ricksportalgun.button.copy"));
        GuiHelper.setTooltip((AbstractWidget)this.moveTo, (Component)Component.m_237115_((String)"tooltip.ricksportalgun.button.move"));
        GuiHelper.setTooltip((AbstractWidget)this.delete, (Component)Component.m_237115_((String)"tooltip.ricksportalgun.button.delete"));
    }

    private void sendPacket(Waypoint waypoint, boolean copy, boolean delete) {
        SBWorkbenchWaypointEditPackage packet = new SBWorkbenchWaypointEditPackage(waypoint, this.selectedWaypoint.getB() == Side.LEFT, copy, delete);
        PGHelper.sendPacketToServer(packet);
    }

    private ItemStack getTopSlotItem() {
        return ((WaypointTransferMenu)this.f_97732_).m_38853_(36).m_7993_();
    }

    private ItemStack getBottomSlotItem() {
        return ((WaypointTransferMenu)this.f_97732_).m_38853_(37).m_7993_();
    }

    private ItemStack getItem(Side side) {
        return side == Side.LEFT ? this.getTopSlotItem() : this.getBottomSlotItem();
    }

    public void m_181908_() {
        super.m_181908_();
        ItemStack leftStack = this.getTopSlotItem();
        ItemStack rightStack = this.getBottomSlotItem();
        if (this.leftWaypointList != null) {
            this.leftWaypointList.refreshEntries(leftStack);
        }
        if (this.rightWaypointList != null) {
            this.rightWaypointList.refreshEntries(rightStack);
        }
        if (this.selectedWaypoint != null && (this.selectedWaypoint.getB() == Side.LEFT && leftStack.m_41619_() || this.selectedWaypoint.getB() == Side.RIGHT && rightStack.m_41619_())) {
            this.selectedWaypoint = null;
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        super.m_88315_(graphics, mouseX, mouseY, delta);
        GuiHelper.renderWidgets(graphics, mouseX, mouseY, delta, new AbstractWidget[0]);
        if (this.leftWaypointList != null) {
            this.leftWaypointList.m_88315_(graphics, mouseX, mouseY, delta);
        }
        if (this.rightWaypointList != null) {
            this.rightWaypointList.m_88315_(graphics, mouseX, mouseY, delta);
        }
        if (this.selectedWaypoint != null) {
            this.delete.m_88315_(graphics, mouseX, mouseY, delta);
            ItemStack opposite = this.getItem(((Side)((Object)this.selectedWaypoint.getB())).opposite());
            if (!opposite.m_41619_()) {
                CompoundTag tag = opposite.m_41784_();
                if (!opposite.m_204117_(PGTags.Items.PORTAL_GUNS) || opposite.m_204117_(PGTags.Items.PORTAL_GUNS) && tag.m_128441_("WaypointUpgrade")) {
                    this.copy.m_88315_(graphics, mouseX, mouseY, delta);
                    this.moveTo.m_88315_(graphics, mouseX, mouseY, delta);
                }
            }
            this.renderWaypointInfo(graphics, mouseX, mouseY, delta);
        }
        this.m_280072_(graphics, mouseX, mouseY);
    }

    private void renderWaypointInfo(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        Waypoint waypoint = (Waypoint)this.selectedWaypoint.getA();
        GuiHelper.drawWhiteString(graphics, (Component)Component.m_237110_((String)"ricksportalgun.name", (Object[])new Object[]{""}), this.f_96543_ / 2 - 172, this.f_96544_ / 2 - 96);
        GuiHelper.renderScrollingString(graphics, (Component)Component.m_237113_((String)waypoint.getName()), this.f_96543_ / 2 - 172, this.f_96544_ / 2 - 84, this.f_96543_ / 2 - 100, this.f_96544_ / 2 - 74, Color.WHITE.getRGB());
        GuiHelper.drawWhiteString(graphics, (Component)Component.m_237110_((String)"ricksportalgun.dimension", (Object[])new Object[]{""}), this.f_96543_ / 2 - 172, this.f_96544_ / 2 - 72);
        GuiHelper.renderScrollingString(graphics, (Component)Component.m_237113_((String)waypoint.getDimension()), this.f_96543_ / 2 - 172, this.f_96544_ / 2 - 60, this.f_96543_ / 2 - 100, this.f_96544_ / 2 - 50, Color.WHITE.getRGB());
        GuiHelper.drawWhiteString(graphics, (Component)Component.m_237110_((String)"ricksportalgun.x", (Object[])new Object[]{waypoint.getX()}), this.f_96543_ / 2 - 172, this.f_96544_ / 2 - 48);
        GuiHelper.drawWhiteString(graphics, (Component)Component.m_237110_((String)"ricksportalgun.y", (Object[])new Object[]{waypoint.getY()}), this.f_96543_ / 2 - 172, this.f_96544_ / 2 - 36);
        GuiHelper.drawWhiteString(graphics, (Component)Component.m_237110_((String)"ricksportalgun.z", (Object[])new Object[]{waypoint.getZ()}), this.f_96543_ / 2 - 172, this.f_96544_ / 2 - 24);
    }

    protected void m_7286_(GuiGraphics graphics, float pPartialTick, int pMouseX, int pMouseY) {
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        if (this.selectedWaypoint != null) {
            graphics.m_280163_(WP_INFO_BG, this.f_96543_ / 2 - 180, y, 0.0f, 0.0f, 128, 256, 128, 256);
        }
        graphics.m_280163_(BG, x + 12, y, 0.0f, 0.0f, this.f_97726_, this.f_97727_, 256, 256);
    }

    public static enum Side {
        LEFT,
        RIGHT;


        public Side opposite() {
            return this == LEFT ? RIGHT : LEFT;
        }
    }
}

