/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.item;

import com.jdolphin.ricksportalgun.common.entity.PortalEntity;
import com.jdolphin.ricksportalgun.common.init.PGItems;
import com.jdolphin.ricksportalgun.common.init.PGTags;
import com.jdolphin.ricksportalgun.common.item.IWaypointStorage;
import com.jdolphin.ricksportalgun.common.item.upgrade.AbstractUpgradeItem;
import com.jdolphin.ricksportalgun.common.util.PortalGunStyle;
import com.jdolphin.ricksportalgun.common.util.helper.LevelHelper;
import com.jdolphin.ricksportalgun.common.util.helper.PGHelper;
import java.awt.Color;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class PortalGunItem
extends Item
implements IWaypointStorage,
ItemColor {
    private final int tints;

    public PortalGunItem(Item.Properties properties, int tints) {
        super(properties);
        this.tints = tints;
    }

    public int getTints() {
        return this.tints;
    }

    public static int getMaxFuel(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return tag.m_128441_("MaxFuel") ? tag.m_128451_("MaxFuel") : 64;
    }

    public static int getFuel(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return tag.m_128441_("Fuel") ? tag.m_128451_("Fuel") : PortalGunItem.getMaxFuel(stack);
    }

    public static void lowerFuel(ItemStack stack, int amount) {
        int i = PortalGunItem.getFuel(stack);
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_("Fuel", Math.max(0, i - amount));
    }

    public static void setPrimaryDye(ItemStack stack, int color) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_("PrimaryColor", color);
    }

    public static void setSecondaryDye(ItemStack stack, int color) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_("SecondaryColor", color);
    }

    public static int getPrimaryDye(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return tag.m_128441_("PrimaryColor") ? tag.m_128451_("PrimaryColor") : 0xF3FBFB;
    }

    public static int getSecondaryDye(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return tag.m_128441_("SecondaryColor") ? tag.m_128451_("SecondaryColor") : 0xF3FBFB;
    }

    public static void setCode(ItemStack stack, String code) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128359_("Code", code);
    }

    public static String getCode(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return tag.m_128441_("Code") ? tag.m_128461_("Code") : "";
    }

    public static void refillFuel(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_("Fuel", PortalGunItem.getMaxFuel(stack));
    }

    public static void migrateDamage(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        int fuel = PortalGunItem.getMaxFuel(stack) - stack.m_41773_();
        tag.m_128405_("Fuel", fuel);
        tag.m_128473_("Damage");
    }

    public static boolean refuel(ItemStack stack, Player player) {
        CompoundTag tag = stack.m_41784_();
        InteractionHand pgHand = PGHelper.getPortalGunHand(player);
        InteractionHand fluidHand = PGHelper.getOppositeHand(pgHand);
        ItemStack gunStack = player.m_21120_(pgHand);
        ItemStack fluidStack = player.m_21120_(fluidHand);
        if (PortalGunItem.getFuel(stack) < PortalGunItem.getMaxFuel(stack) && gunStack.m_204117_(PGTags.Items.PORTAL_GUNS)) {
            if (fluidStack.m_150930_(PGItems.PORTAL_FLUID)) {
                PortalGunItem.refillFuel(stack);
                fluidStack.m_41774_(1);
                tag.m_128379_("Bootleg", false);
                return true;
            }
            if (fluidStack.m_150930_(PGItems.BOOTLEG_PORTAL_FLUID)) {
                PortalGunItem.refillFuel(stack);
                tag.m_128379_("Bootleg", false);
                fluidStack.m_41774_(1);
                return true;
            }
        }
        return false;
    }

    private Vec3 getLocation(Level level, BlockPos bPos, Direction dir, Vec3 loc) {
        if (this.isAir(level, bPos.m_7495_()) && dir == Direction.DOWN) {
            return loc.m_82520_(0.0, -0.2, 0.0);
        }
        if (dir.equals((Object)Direction.UP)) {
            return loc;
        }
        if (!this.isAir(level, bPos.m_121945_(dir))) {
            switch (dir) {
                case NORTH: {
                    Vec3 vec = bPos.m_122012_().m_252807_();
                    loc = vec.m_82520_(0.0, 0.0, 0.4);
                    break;
                }
                case SOUTH: {
                    Vec3 vec = bPos.m_122019_().m_252807_();
                    loc = vec.m_82520_(0.0, 0.0, -0.4);
                    break;
                }
                case WEST: {
                    Vec3 vec = bPos.m_122024_().m_252807_();
                    loc = vec.m_82520_(0.4, 0.0, 0.0);
                    break;
                }
                case EAST: {
                    Vec3 vec = bPos.m_122029_().m_252807_();
                    loc = vec.m_82520_(-0.4, 0.0, 0.0);
                }
            }
        } else {
            float x;
            float f = dir.m_122434_().equals((Object)Direction.Axis.X) ? (dir.m_122421_().equals((Object)Direction.AxisDirection.POSITIVE) ? 0.1f : -0.1f) : (x = 0.0f);
            float z = dir.m_122434_().equals((Object)Direction.Axis.Z) ? (dir.m_122421_().equals((Object)Direction.AxisDirection.POSITIVE) ? 0.1f : -0.1f) : 0.0f;
            loc = new Vec3(loc.m_7096_() + (double)x, (double)bPos.m_123342_(), loc.m_7094_() + (double)z);
        }
        return loc;
    }

    /*
     * Enabled aggressive block sorting
     */
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        int age;
        ItemStack stack = player.m_21120_(hand);
        if (level.m_5776_()) return InteractionResultHolder.m_19098_((Object)stack);
        if (!(player instanceof ServerPlayer)) return InteractionResultHolder.m_19098_((Object)stack);
        PortalGunItem.migrateDamage(stack);
        if (!PGHelper.canPlayerAccessGun(player, stack)) {
            PGHelper.sendFailMsg(player, "error.ricksportalgun.security");
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        ItemStack oppositeStack = player.m_21120_(PGHelper.getOppositeHand(hand));
        BlockHitResult hitResult = PortalGunItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        CompoundTag tag = stack.m_41784_();
        if (PortalGunItem.refuel(stack, player)) return InteractionResultHolder.m_19098_((Object)stack);
        if (PortalGunItem.getFuel(stack) <= 0) return InteractionResultHolder.m_19098_((Object)stack);
        Item item = oppositeStack.m_41720_();
        if (item instanceof AbstractUpgradeItem) {
            AbstractUpgradeItem upgrade = (AbstractUpgradeItem)item;
            InteractionResult result = upgrade.applyUpgrade(player, stack, this);
            if (player.m_7500_()) return InteractionResultHolder.m_19090_((Object)stack);
            oppositeStack.m_41774_(1);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        ResourceLocation dim = tag.m_128441_("PortalDimension") ? new ResourceLocation(tag.m_128461_("PortalDimension")) : Level.f_46428_.m_135782_();
        ResourceKey<Level> key = LevelHelper.getWorldKey(dim);
        ServerLevel serverlevel = LevelHelper.getServerWorld(level, key);
        BlockPos destination = PortalGunItem.getHopCoords(stack);
        Vec3 loc = hitResult.m_82450_();
        if (hitResult.m_6662_().equals((Object)HitResult.Type.BLOCK)) {
            Direction dir = hitResult.m_82434_();
            BlockPos bPos = hitResult.m_82425_();
            loc = this.getLocation(level, bPos, dir, loc);
        }
        Direction hitDir = hitResult.m_82434_();
        Direction playerDir = player.m_6350_();
        float size = tag.m_128441_("PortalSize") ? tag.m_128457_("PortalSize") : 1.0f;
        int n = age = tag.m_128441_("PortalAge") ? tag.m_128451_("PortalAge") : 10;
        if (serverlevel != null) {
            if (LevelHelper.canPortalTo(serverlevel, destination, stack) && LevelHelper.canPortalTo((ServerLevel)level, hitResult.m_82425_(), stack)) {
                if (PortalGunItem.canBypassDragon(stack) || !LevelHelper.endHasDragons((ServerLevel)level) && !LevelHelper.endHasDragons(serverlevel)) {
                    PortalEntity portal = new PortalEntity(level, loc, hitDir, playerDir, size);
                    serverlevel.m_7726_().m_6692_(new ChunkPos(destination), true);
                    PortalEntity exPortal = new PortalEntity((Level)serverlevel, destination.m_7494_().m_252807_(), hitDir, playerDir, size);
                    boolean bootleg = tag.m_128441_("Bootleg") && tag.m_128471_("Bootleg");
                    this.doForBoth(entity -> {
                        entity.setLifetime(PGHelper.seconds(age));
                        entity.setColor(PortalGunItem.getColor(stack));
                        entity.setBootleg(bootleg);
                    }, portal, exPortal);
                    if (stack.m_41788_()) {
                        Component component = stack.m_41786_();
                        String s = component.getString();
                        this.doForBoth(entity -> entity.m_6593_((Component)Component.m_237113_((String)s)), portal, exPortal);
                    }
                    portal.setHopLocation(dim, destination);
                    exPortal.setHopLocation(level.m_46472_().m_135782_(), portal.m_20183_());
                    if (!portal.isFlat()) {
                        this.doForBoth(entity -> entity.m_146922_(player.m_146908_()), portal, exPortal);
                    }
                    serverlevel.m_7654_().m_201446_(() -> serverlevel.m_7967_((Entity)exPortal));
                    level.m_7967_((Entity)portal);
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                    player.m_36335_().m_41524_((Item)this, 60);
                    if (player.m_7500_()) return InteractionResultHolder.m_19098_((Object)stack);
                    PortalGunItem.lowerFuel(stack, 1);
                    return InteractionResultHolder.m_19098_((Object)stack);
                }
                PGHelper.sendFailMsg(player, "error.ricksportalgun.destination.dragon");
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            PGHelper.sendFailMsg(player, "error.ricksportalgun.destination.unreachable");
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (!LevelHelper.isBlenderDestination(dim.toString())) return InteractionResultHolder.m_19098_((Object)stack);
        PortalEntity portal = new PortalEntity(level, loc, hitDir, playerDir, size);
        portal.setLifetime(PGHelper.seconds(age));
        if (stack.m_41788_()) {
            Component component = stack.m_41786_();
            String s = component.getString();
            portal.m_6593_((Component)Component.m_237113_((String)s));
        }
        portal.setHopLocation(dim, destination);
        portal.setColor(PortalGunItem.getColor(stack));
        boolean bootleg = tag.m_128441_("Bootleg") && tag.m_128471_("Bootleg");
        portal.setBootleg(bootleg);
        if (!portal.isFlat()) {
            portal.m_146922_(player.m_146908_());
        }
        if (!player.m_7500_()) {
            PortalGunItem.lowerFuel(stack, 1);
        }
        level.m_7967_((Entity)portal);
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        player.m_36335_().m_41524_((Item)this, 60);
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    private void doForBoth(Consumer<PortalEntity> consumer, PortalEntity a, PortalEntity b) {
        consumer.accept(a);
        consumer.accept(b);
    }

    public static boolean canBypassDragon(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return tag.m_128441_("ExtraDimMk2") && tag.m_128471_("ExtraDimMk2");
    }

    private boolean isAir(Level level, BlockPos pos) {
        return level.m_8055_(pos).m_60795_();
    }

    public void m_7373_(ItemStack stack, Level pLevel, List<Component> tooltips, TooltipFlag pIsAdvanced) {
        CompoundTag tag = stack.m_41784_();
        List<String> list = IWaypointStorage.getWaypoints(stack);
        if (!Screen.m_96638_()) {
            tooltips.add((Component)Component.m_237110_((String)"ricksportalgun.destination", (Object[])new Object[]{PortalGunItem.getHopCoords(stack).m_123341_(), PortalGunItem.getHopCoords(stack).m_123342_(), PortalGunItem.getHopCoords(stack).m_123343_()}).m_130940_(ChatFormatting.GRAY));
            tooltips.add((Component)Component.m_237110_((String)"ricksportalgun.dimension", (Object[])new Object[]{PortalGunItem.getHopDimension(stack).toString()}).m_130940_(ChatFormatting.GRAY));
            tooltips.add((Component)Component.m_237110_((String)"tooltip.ricksportalgun.fuel", (Object[])new Object[]{PortalGunItem.getFuel(stack), PortalGunItem.getMaxFuel(stack)}).m_130940_(ChatFormatting.GRAY));
        } else {
            tooltips.add((Component)Component.m_237110_((String)"tooltip.ricksportalgun.waypoints", (Object[])new Object[]{list.size()}).m_130940_(ChatFormatting.GRAY));
            if (tag.m_128441_("PrimaryColor") || tag.m_128441_("SecondaryColor")) {
                tooltips.add((Component)Component.m_237110_((String)"item.dyed", (Object[])new Object[]{list.size()}).m_130944_(new ChatFormatting[]{ChatFormatting.DARK_PURPLE, ChatFormatting.ITALIC}));
            }
        }
    }

    public int m_142159_(ItemStack stack) {
        return PortalGunItem.getColor(stack);
    }

    public boolean m_142522_(ItemStack stack) {
        return PortalGunItem.getFuel(stack) < PortalGunItem.getMaxFuel(stack);
    }

    public int m_142158_(ItemStack stack) {
        return Math.round((float)PortalGunItem.getFuel(stack) * 13.0f / (float)PortalGunItem.getMaxFuel(stack));
    }

    public static int getColor(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return tag.m_128441_("Color") ? tag.m_128451_("Color") : PortalGunItem.getDefaultColor(stack);
    }

    public static void setDefaultColor(ItemStack stack, int color) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_("DefaultColor", color);
    }

    public static int getDefaultColor(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return tag.m_128441_("DefaultColor") ? tag.m_128451_("DefaultColor") : Color.GREEN.getRGB();
    }

    public static void setStyle(ItemStack stack, PortalGunStyle style) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128365_("PortalGunStyle", (Tag)style.toNBT());
    }

    public static void setColor(ItemStack stack, int color) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_("Color", color);
    }

    public static void setHopLocation(ItemStack stack, ResourceLocation dimension, BlockPos pos) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128359_("PortalDimension", dimension.toString());
        tag.m_128365_("PortalPos", (Tag)NbtUtils.m_129224_((BlockPos)pos));
    }

    public static ResourceLocation getHopDimension(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return tag.m_128441_("PortalDimension") ? new ResourceLocation(tag.m_128461_("PortalDimension")) : Level.f_46428_.m_135782_();
    }

    public static BlockPos getHopCoords(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("PortalPos")) {
            CompoundTag bpTag = tag.m_128469_("PortalPos");
            return NbtUtils.m_129239_((CompoundTag)bpTag);
        }
        return BlockPos.f_121853_;
    }

    public int m_92671_(ItemStack itemStack, int i) {
        return PortalGunItem.getColor(itemStack);
    }
}

