/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.menu.workbench;

import com.jdolphin.ricksportalgun.common.init.PGMenuTypes;
import com.jdolphin.ricksportalgun.common.item.IWaypointStorage;
import com.jdolphin.ricksportalgun.common.menu.workbench.AbstractWorkbenchMenu;
import com.jdolphin.ricksportalgun.common.util.Waypoint;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class WaypointTransferMenu
extends AbstractWorkbenchMenu {
    private final Container container;
    private final ContainerData data;
    private final ContainerLevelAccess access;

    public WaypointTransferMenu(int containerId, Inventory playerInventory) {
        this(containerId, playerInventory, (Container)new SimpleContainer(10), (ContainerData)new SimpleContainerData(2), ContainerLevelAccess.f_39287_);
    }

    public WaypointTransferMenu(int i, Inventory inventory, Container container, ContainerData data, ContainerLevelAccess access) {
        super(PGMenuTypes.WORKBENCH_WAYPOINT_TRANSFER, i, access);
        this.data = data;
        this.access = access;
        this.container = container;
        this.m_38884_(data);
        WaypointTransferMenu.m_38869_((Container)container, (int)10);
        WaypointTransferMenu.m_38886_((ContainerData)data, (int)2);
        this.addInventoryExtendedSlots((Container)inventory, 25, 129);
        this.addInventoryHotbarSlots((Container)inventory, 25, 187);
        this.addSlots(container);
    }

    protected void addSlots(Container container) {
        this.m_38897_(new Slot(container, 5, 97, 44){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_41720_() instanceof IWaypointStorage;
            }
        });
        this.m_38897_(new Slot(container, 6, 97, 73){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_41720_() instanceof IWaypointStorage;
            }
        });
    }

    public void editWaypoints(Waypoint waypoint, boolean side, boolean copy, boolean remove) {
        this.access.m_39292_((level, pos) -> {
            if (!level.f_46443_) {
                ItemStack left = this.m_38853_(36).m_7993_();
                ItemStack right = this.m_38853_(37).m_7993_();
                if (copy) {
                    if (side) {
                        IWaypointStorage.addWaypoint(right, waypoint);
                    } else {
                        IWaypointStorage.addWaypoint(left, waypoint);
                    }
                } else if (remove) {
                    if (side) {
                        IWaypointStorage.deleteWaypoint(left, waypoint);
                    } else {
                        IWaypointStorage.deleteWaypoint(right, waypoint);
                    }
                } else if (side) {
                    IWaypointStorage.addWaypoint(right, waypoint);
                    IWaypointStorage.deleteWaypoint(left, waypoint);
                } else {
                    IWaypointStorage.addWaypoint(left, waypoint);
                    IWaypointStorage.deleteWaypoint(right, waypoint);
                }
            }
        });
    }

    public ItemStack m_7648_(Player player, int i) {
        Slot fromSlot = this.m_38853_(i);
        ItemStack fromStack = fromSlot.m_7993_();
        if (fromStack.m_41613_() <= 0) {
            fromSlot.m_5852_(ItemStack.f_41583_);
        }
        if (!fromSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack copyFromStack = fromStack.m_41777_();
        if (i < 36) {
            if (!this.m_38903_(fromStack, 36, 38, false)) {
                return ItemStack.f_41583_;
            }
        } else if (i < 38) {
            if (!this.m_38903_(fromStack, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
        } else {
            System.err.println("Invalid slot index: " + i);
            return ItemStack.f_41583_;
        }
        fromSlot.m_6654_();
        fromSlot.m_142406_(player, fromStack);
        return copyFromStack;
    }

    public boolean m_6875_(Player player) {
        return this.container.m_6542_(player);
    }
}

