/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.jdolphin.ricksportalgun.common.blockentity.GunWorkbenchBlockEntity;
import com.jdolphin.ricksportalgun.common.init.PGRecipeSerializers;
import com.jdolphin.ricksportalgun.common.init.PGRecipeTypes;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;

public class PortalGunWorkbenchRecipe
implements Recipe<Container> {
    private final List<ItemStack> items;
    final ItemStack result;

    public PortalGunWorkbenchRecipe(List<ItemStack> itemStacks, ItemStack result) {
        this.items = itemStacks;
        this.result = result;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public List<ItemStack> getInputs() {
        return this.items;
    }

    public boolean m_5818_(Container container, Level level) {
        GunWorkbenchBlockEntity workbench;
        List<ItemStack> ingredients;
        int count;
        if (!level.f_46443_ && container instanceof GunWorkbenchBlockEntity && (count = (ingredients = (workbench = (GunWorkbenchBlockEntity)container).ingredients()).stream().toList().size()) == this.items.size()) {
            for (int i = 0; i < this.items.size(); ++i) {
                ItemStack stack = ingredients.get(i);
                ItemStack ingredient = this.items.get(i);
                if (stack.m_41613_() < ingredient.m_41613_()) {
                    return false;
                }
                if (ItemStack.m_41728_((ItemStack)stack, (ItemStack)ingredient)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int i, int i1) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.result;
    }

    public ResourceLocation m_6423_() {
        return null;
    }

    public RecipeSerializer<? extends Recipe<Container>> m_7707_() {
        return PGRecipeSerializers.WORKBENCH_SERIALIZER;
    }

    public RecipeType<? extends Recipe<Container>> m_6671_() {
        return PGRecipeTypes.WORKBENCH_TYPE;
    }

    public static class Serializer
    implements RecipeSerializer<PortalGunWorkbenchRecipe> {
        public PortalGunWorkbenchRecipe fromJson(ResourceLocation resourceLocation, JsonObject json) {
            ItemStack output = Serializer.itemStackFromJson(GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
            NonNullList inputs = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
            for (int i = 0; i < ingredients.size(); ++i) {
                inputs.set(i, (Object)Serializer.itemStackFromJson(ingredients.get(i).getAsJsonObject()));
            }
            return new PortalGunWorkbenchRecipe((List<ItemStack>)inputs, output);
        }

        public static ItemStack itemStackFromJson(JsonObject stackObject) {
            Item item = ShapedRecipe.m_151278_((JsonObject)stackObject);
            ItemStack stack = item.m_7968_();
            if (stackObject.has("data")) {
                JsonObject dataObject = stackObject.getAsJsonObject("data");
                if (dataObject.has("potion")) {
                    Potion potion = Potion.m_43489_((String)GsonHelper.m_13906_((JsonObject)dataObject, (String)"potion"));
                    PotionUtils.m_43549_((ItemStack)stack, (Potion)potion);
                }
            } else {
                int i = GsonHelper.m_13824_((JsonObject)stackObject, (String)"count", (int)1);
                if (i < 1) {
                    throw new JsonSyntaxException("Invalid output count: " + i);
                }
                stack.m_41764_(i);
            }
            return stack;
        }

        public PortalGunWorkbenchRecipe fromNetwork(ResourceLocation resourceLocation, FriendlyByteBuf buf) {
            NonNullList inputs = NonNullList.m_122780_((int)buf.readInt(), (Object)ItemStack.f_41583_);
            inputs.replaceAll(ignored -> buf.m_130267_());
            ItemStack output = buf.m_130267_();
            return new PortalGunWorkbenchRecipe((List<ItemStack>)inputs, output);
        }

        public void toNetwork(FriendlyByteBuf buf, PortalGunWorkbenchRecipe recipe) {
            buf.writeInt(recipe.items.size() - 1);
            for (Ingredient ingredient : recipe.m_7527_()) {
                ingredient.m_43923_(buf);
            }
            buf.m_130055_(recipe.m_8043_(null));
        }
    }
}

