/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.blockentity;

import com.jdolphin.ricksportalgun.common.init.PGBlockEntities;
import com.jdolphin.ricksportalgun.common.init.PGRecipeTypes;
import com.jdolphin.ricksportalgun.common.menu.workbench.SkinSelectorMenu;
import com.jdolphin.ricksportalgun.common.menu.workbench.WaypointTransferMenu;
import com.jdolphin.ricksportalgun.common.menu.workbench.WorkbenchCraftingMenu;
import com.jdolphin.ricksportalgun.common.recipe.PortalGunWorkbenchRecipe;
import com.jdolphin.ricksportalgun.common.util.helper.PGHelper;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class GunWorkbenchBlockEntity
extends RandomizableContainerBlockEntity
implements MenuProvider {
    public static final String TAG_MODE = "WorkbenchMode";
    public static final String TAG_PROGRESS = "CraftProgress";
    private MenuType menuType = MenuType.CRAFTING;
    public static final int OUTPUT_SLOT = 4;
    protected final ContainerData data;
    private int progress = 0;
    private int maxProgress = PGHelper.seconds(3);
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)10, (Object)ItemStack.f_41583_);

    public GunWorkbenchBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(PGBlockEntities.GUN_WORKBENCH, pPos, pBlockState);
        this.data = new ContainerData(){

            public int m_6413_(int pIndex) {
                return switch (pIndex) {
                    case 0 -> GunWorkbenchBlockEntity.this.progress;
                    case 1 -> GunWorkbenchBlockEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void m_8050_(int pIndex, int pValue) {
                switch (pIndex) {
                    case 0: {
                        GunWorkbenchBlockEntity.this.progress = pValue;
                        break;
                    }
                    case 1: {
                        GunWorkbenchBlockEntity.this.maxProgress = pValue;
                    }
                }
            }

            public int m_6499_() {
                return 2;
            }
        };
    }

    public List<ItemStack> ingredients() {
        return this.items.subList(0, 4);
    }

    public AbstractContainerMenu m_6555_(int pContainerId, Inventory inventory) {
        return this.menuType.fac.create(pContainerId, inventory, this, this.data, ContainerLevelAccess.m_39289_((Level)this.f_58857_, (BlockPos)this.f_58858_));
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.menuType = MenuType.values()[tag.m_128451_(TAG_MODE)];
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        this.progress = tag.m_128451_(TAG_PROGRESS);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_(TAG_MODE, this.menuType.ordinal());
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
        tag.m_128405_(TAG_PROGRESS, this.progress);
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T t) {
        ((GunWorkbenchBlockEntity)t).baseTick(level, pos, state);
    }

    private boolean hasCraftingFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftingProgress() {
        ++this.progress;
    }

    private void baseTick(Level level, BlockPos pos, BlockState state) {
        if (this.hasRecipe()) {
            if (!this.hasCraftingFinished()) {
                this.increaseCraftingProgress();
            }
            this.m_6596_();
            if (this.hasCraftingFinished() && this.craftItem()) {
                this.resetProgress();
            }
        } else {
            this.resetProgress();
        }
    }

    private boolean craftItem() {
        Optional<PortalGunWorkbenchRecipe> holder = this.getCurrentRecipe();
        if (holder.isPresent()) {
            PortalGunWorkbenchRecipe recipe = holder.get();
            ItemStack output = recipe.getResult();
            ItemStack result = output.m_41777_();
            ItemStack inOutputSlot = this.m_8020_(4);
            if (inOutputSlot.m_41619_()) {
                this.lowerInputs(recipe);
                this.m_6836_(4, result);
                return true;
            }
            if (ItemStack.m_150942_((ItemStack)inOutputSlot, (ItemStack)result)) {
                int i = inOutputSlot.m_41613_();
                int j = result.m_41613_();
                result.m_41764_(i + j);
                this.lowerInputs(recipe);
                this.m_6836_(4, result);
                return true;
            }
            return false;
        }
        return false;
    }

    public void setMenuType(int i) {
        this.menuType = MenuType.values()[i];
    }

    private void lowerInputs(PortalGunWorkbenchRecipe recipe) {
        List<ItemStack> stacks = recipe.getInputs();
        for (ItemStack stack : stacks) {
            for (ItemStack invStack : this.ingredients()) {
                if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)invStack)) continue;
                int i = stack.m_41613_();
                int j = invStack.m_41613_();
                int result = Math.max(j - i, 0);
                invStack.m_41764_(result);
            }
        }
    }

    private void clearInputs() {
        for (int i = 0; i < 4; ++i) {
            this.m_6836_(i, ItemStack.f_41583_);
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private boolean hasRecipe() {
        Optional<PortalGunWorkbenchRecipe> recipe = this.getCurrentRecipe();
        if (recipe.isPresent()) {
            ItemStack output = recipe.get().getResult();
            return this.m_7013_(4, output);
        }
        return false;
    }

    private Optional<PortalGunWorkbenchRecipe> getCurrentRecipe() {
        return this.f_58857_.m_7465_().m_44015_(PGRecipeTypes.WORKBENCH_TYPE, (Container)this, this.f_58857_);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"menu.ricksportalgun.workbench");
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"menu.ricksportalgun.workbench");
    }

    protected NonNullList<ItemStack> m_7086_() {
        return this.items;
    }

    protected void m_6520_(NonNullList<ItemStack> nonNullList) {
        this.items = nonNullList;
    }

    public int m_6643_() {
        return 10;
    }

    public static enum MenuType {
        WAYPOINT_TRANSFER(WaypointTransferMenu::new),
        SKIN_SELECTOR(SkinSelectorMenu::new),
        CRAFTING(WorkbenchCraftingMenu::new);

        final IMenuFactory<AbstractContainerMenu> fac;

        private MenuType(IMenuFactory<AbstractContainerMenu> factory) {
            this.fac = factory;
        }
    }

    public static interface IMenuFactory<T extends AbstractContainerMenu> {
        public T create(int var1, Inventory var2, GunWorkbenchBlockEntity var3, ContainerData var4, ContainerLevelAccess var5);
    }
}

