/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.blockentity;

import com.jdolphin.ricksportalgun.common.block.PortalDispenserBlock;
import com.jdolphin.ricksportalgun.common.entity.PortalEntity;
import com.jdolphin.ricksportalgun.common.init.PGBlockEntities;
import com.jdolphin.ricksportalgun.common.init.PGItems;
import com.jdolphin.ricksportalgun.common.menu.PortalDispenserMenu;
import com.jdolphin.ricksportalgun.common.util.helper.LevelHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class PortalDispenserBlockEntity
extends BaseContainerBlockEntity {
    public static final String TAG_FUEL = "Fuel";
    public static final String TAG_MAX_FUEL = "MaxFuel";
    public static final String TAG_COLOR = "Color";
    public static final String TAG_DEST_DIM = "DestinationDim";
    public static final String TAG_DEST_BPOS = "DestinationPos";
    public static final String TAG_DIRECTION = "Direction";
    private Direction dir;
    private int fuel = 16;
    private int maxFuel = 16;
    private String desDim = "minecraft:overworld";
    private BlockPos desPos = BlockPos.f_121853_;
    protected final ContainerData dataAccess;
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);

    public PortalDispenserBlockEntity(BlockPos pos, BlockState blockState) {
        super(PGBlockEntities.PORTAL_DISPENSER, pos, blockState);
        this.dataAccess = new ContainerData(){

            public int m_6413_(int i) {
                switch (i) {
                    case 0: {
                        return PortalDispenserBlockEntity.this.fuel;
                    }
                    case 1: {
                        return PortalDispenserBlockEntity.this.maxFuel;
                    }
                }
                return 0;
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: {
                        PortalDispenserBlockEntity.this.fuel = value;
                        break;
                    }
                    case 1: {
                        PortalDispenserBlockEntity.this.maxFuel = value;
                    }
                }
            }

            public int m_6499_() {
                return 2;
            }
        };
    }

    public void setDestination(String dimension, BlockPos pos) {
        this.desDim = dimension;
        this.desPos = pos;
    }

    public BlockPos getDestinationPos() {
        return this.desPos;
    }

    public String getDestinationDim() {
        return this.desDim;
    }

    public void m_6596_() {
        ItemStack stack;
        if (!this.hasFuel() && (stack = (ItemStack)this.items.get(0)).m_150930_(PGItems.PORTAL_FLUID)) {
            stack.m_41774_(1);
            this.fuel = this.maxFuel;
        }
        super.m_6596_();
    }

    public boolean m_6542_(Player player) {
        return Container.m_272074_((BlockEntity)this, (Player)player);
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"menu.ricksportalgun.portal_dispenser");
    }

    protected AbstractContainerMenu m_6555_(int i, Inventory inventory) {
        return new PortalDispenserMenu(i, inventory, (Container)this, this.dataAccess, ContainerLevelAccess.m_39289_((Level)this.f_58857_, (BlockPos)this.f_58858_));
    }

    public int getFuel() {
        return this.fuel;
    }

    public boolean hasFuel() {
        return this.fuel > 0;
    }

    public int getMaxFuel() {
        return this.maxFuel;
    }

    public void setFuel(int fuel) {
        this.fuel = Math.min(this.getMaxFuel(), fuel);
    }

    public void decreaseFuel(int amount) {
        this.fuel = Math.max(0, this.fuel - amount);
    }

    public void onActivation(Level level, BlockPos pos) {
        if (!level.f_46443_) {
            BlockState state = level.m_8055_(pos);
            Direction direction = (Direction)state.m_61143_((Property)PortalDispenserBlock.f_52588_);
            BlockPos portalPos = pos;
            if (this.hasFuel()) {
                ResourceLocation dim;
                ServerLevel destLevel;
                for (int j = 0; j < 4 && level.m_8055_((portalPos = pos.m_5484_(direction, j)).m_5484_(direction, 1)).m_60795_(); ++j) {
                }
                if (!this.getDestinationDim().isEmpty() && this.getDestinationPos() != null && LevelHelper.canPortalTo(destLevel = LevelHelper.getServerWorld(level, LevelHelper.getWorldKey(dim = new ResourceLocation(this.getDestinationDim()))), this.getDestinationPos(), null)) {
                    Vec3 vec = Vec3.m_82512_((Vec3i)portalPos).m_82520_((double)direction.m_122429_() * 0.4, (double)direction.m_122430_() * 0.4, (double)direction.m_122431_() * 0.4);
                    PortalEntity portal = new PortalEntity(level, vec, direction, this.dir, 3.0f);
                    PortalEntity exitPortal = new PortalEntity((Level)destLevel, Vec3.m_82512_((Vec3i)this.getDestinationPos()), direction, this.dir, 3.0f);
                    if (!portal.isFlat()) {
                        portal.m_146922_(this.dir.m_122435_());
                        exitPortal.m_146922_(this.dir.m_122435_());
                    }
                    portal.setHopLocation(dim, this.getDestinationPos());
                    exitPortal.setHopLocation(dim, portal.m_20183_());
                    if (destLevel.m_7967_((Entity)exitPortal)) {
                        level.m_7967_((Entity)portal);
                        this.decreaseFuel(1);
                    }
                }
            }
        }
    }

    public void setDirection(Direction direction) {
        this.dir = direction;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.fuel = tag.m_128451_(TAG_FUEL);
        this.maxFuel = tag.m_128451_(TAG_MAX_FUEL);
        CompoundTag bpTag = tag.m_128469_(TAG_DEST_BPOS);
        this.desPos = NbtUtils.m_129239_((CompoundTag)bpTag);
        this.desDim = tag.m_128461_(TAG_DEST_DIM);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        this.dir = Direction.m_122364_((double)tag.m_128459_(TAG_DIRECTION));
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
        tag.m_128405_(TAG_FUEL, this.fuel);
        tag.m_128405_(TAG_MAX_FUEL, this.maxFuel);
        tag.m_128359_(TAG_DEST_DIM, this.desDim);
        tag.m_128365_(TAG_DEST_BPOS, (Tag)NbtUtils.m_129224_((BlockPos)this.desPos));
        tag.m_128347_(TAG_DIRECTION, (double)this.dir.m_122435_());
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        return this.items.isEmpty();
    }

    public ItemStack m_8020_(int i) {
        return (ItemStack)this.items.get(i);
    }

    public ItemStack m_7407_(int i, int i1) {
        return null;
    }

    public ItemStack m_8016_(int i) {
        return null;
    }

    public void m_6836_(int i, ItemStack itemStack) {
        this.items.set(i, (Object)itemStack);
    }

    public void m_6211_() {
        this.items.clear();
    }
}

