/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.packet.serverbound;

import com.jdolphin.ricksportalgun.common.item.PortalGunItem;
import com.jdolphin.ricksportalgun.common.util.helper.PGHelper;
import com.jdolphin.ricksportalgun.common.util.network.PGServerPayload;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public record SBSecuritySettingsPacket(boolean lock, String name, String code, boolean selfDestruct) implements PGServerPayload
{
    @Override
    public void handle(ServerPlayer player) {
        MinecraftServer server = player.f_8924_;
        server.m_201446_(() -> {
            ItemStack stack = player.m_21120_(PGHelper.getPortalGunHand((Player)player));
            CompoundTag tag = stack.m_41784_();
            tag.m_128379_("Lock", this.lock);
            tag.m_128379_("SelfDestruct", this.selfDestruct);
            if (!this.code.isEmpty()) {
                PortalGunItem.setCode(stack, this.code);
            }
            if (!this.name.isEmpty()) {
                ServerPlayer newOwner = server.m_6846_().m_11255_(this.name);
                if (newOwner != null) {
                    tag.m_128362_("Owner", newOwner.m_20148_());
                } else {
                    PGHelper.sendFailMsg((Player)player, Component.m_237110_((String)"error.ricksportalgun.locating.player.not_found", (Object[])new Object[]{this.name}));
                }
            }
            PGHelper.sendSuccessMsg((Player)player, "notice.ricksportalgun.settings.applied");
        });
    }

    public static SBSecuritySettingsPacket decode(FriendlyByteBuf buf) {
        boolean lock = buf.readBoolean();
        String name = buf.m_130277_();
        String code = buf.m_130277_();
        boolean selfDestruct = buf.readBoolean();
        return new SBSecuritySettingsPacket(lock, name, code, selfDestruct);
    }

    @Override
    public ResourceLocation getId() {
        return SBSecuritySettingsPacket.getID();
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeBoolean(this.lock);
        buf.m_130070_(this.name);
        buf.m_130070_(this.code);
        buf.writeBoolean(this.selfDestruct);
    }

    public static ResourceLocation getID() {
        return PGHelper.id("settings");
    }
}

