/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.util.helper;

import com.jdolphin.ricksportalgun.PGConstants;
import com.jdolphin.ricksportalgun.common.blockentity.SubetherBarrierBlockEntity;
import com.jdolphin.ricksportalgun.common.util.helper.PGHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.dimension.end.EndDragonFight;
import net.minecraft.world.level.levelgen.Heightmap;

public class LevelHelper {
    public static List<String> DIMENSIONS = new ArrayList<String>();
    public static List<String> CLIENT_DIMENSIONS = new ArrayList<String>();

    public static void addDimension(String dim) {
        if (!DIMENSIONS.contains(dim)) {
            DIMENSIONS.add(dim);
        }
    }

    public static void addDimensions(List<String> dims) {
        for (String s : dims) {
            LevelHelper.addDimension(s);
        }
    }

    public static boolean isBlenderDestination(String s) {
        return PGHelper.id("blender").toString().equals(s);
    }

    public static List<String> getDimensionsAsString(Iterable<ServerLevel> levels, List<String> list) {
        levels.forEach(world -> {
            ResourceLocation worldKey = world.m_46472_().m_135782_();
            String s = worldKey.toString();
            if (!s.isEmpty() && !list.contains(s)) {
                list.add(s);
            }
        });
        return list;
    }

    public static List<String> getDimensionsAsString(Iterable<ServerLevel> levels) {
        return LevelHelper.getDimensionsAsString(levels, new ArrayList<String>());
    }

    public static List<BlockEntity> getBlockEntitiesInChunks(ServerLevel level, ChunkPos pos, int radius) {
        if (level != null) {
            ArrayList<BlockEntity> list = new ArrayList<BlockEntity>();
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    list.addAll(level.m_6325_(pos.f_45578_ + x, pos.f_45579_ + z).m_62954_().values());
                }
            }
            return list;
        }
        return List.of();
    }

    public static boolean canPortalTo(ServerLevel level, BlockPos pos, ItemStack stack) {
        if (level != null) {
            CompoundTag tag = stack.m_41784_();
            String code = tag.m_128441_("Code") ? tag.m_128461_("Code") : "";
            List<BlockEntity> blockEntities = LevelHelper.getBlockEntitiesInChunks(level, new ChunkPos(pos), 3);
            for (BlockEntity be : blockEntities) {
                if (!(be instanceof SubetherBarrierBlockEntity)) continue;
                SubetherBarrierBlockEntity barrier = (SubetherBarrierBlockEntity)be;
                return !barrier.canBlockPortal((Level)level, barrier.m_58899_(), code);
            }
            return true;
        }
        return false;
    }

    public static ResourceKey<Level> getWorldKey(ResourceLocation dimension) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)dimension);
    }

    public static ServerLevel getServerWorld(Level level, ResourceKey<Level> dimension) {
        return level.m_7654_().m_129880_(dimension);
    }

    public static ResourceLocation getPlayerDimensionLocation(Player player) {
        return LevelHelper.getLevelDimensionLocation(player.m_9236_());
    }

    public static BlockPos getRandomCoord(ServerLevel level, int radius) {
        WorldBorder border = level.m_6857_();
        RandomSource rand = level.m_213780_();
        int min = radius < 1000 ? 10 : 100;
        int xCoord = rand.m_216339_(min, radius);
        int yCoord = Mth.m_216271_((RandomSource)rand, (int)(level.m_141937_() + 1), (int)level.m_151558_());
        int zCoord = rand.m_216339_(min, radius);
        return border.m_187569_((double)xCoord, (double)yCoord, (double)zCoord);
    }

    public static ServerLevel getRandomServerLevel(MinecraftServer server) {
        Iterable worlds = server.m_129785_();
        ArrayList worldList = new ArrayList();
        worlds.forEach(world -> {
            if (world != null) {
                worldList.add(world);
            }
        });
        return (ServerLevel)worldList.get(PGConstants.RANDOM.nextInt(worldList.size()));
    }

    public static void randomTP(ServerPlayer player, int radius, boolean interdimensional) {
        ServerLevel level = player.m_284548_();
        ServerLevel dest = LevelHelper.getRandomServerLevel(player.f_8924_);
        LevelHelper.teleportEntity((Entity)player, interdimensional ? dest : level, LevelHelper.getSafePos(LevelHelper.getRandomCoord(dest, radius), level));
    }

    public static BlockPos getSafePos(BlockPos bPos, ServerLevel level) {
        return LevelHelper.getSafePos(bPos, level, 0);
    }

    private static BlockPos getSafePos(BlockPos bPos, ServerLevel level, int iteration) {
        BlockPos pos1;
        int y;
        int direction;
        ++iteration;
        ChunkAccess chunk = level.m_46865_(bPos);
        level.m_8602_(chunk.m_7697_().f_45578_, chunk.m_7697_().f_45579_, true);
        int height = level.m_6924_(Heightmap.Types.WORLD_SURFACE, bPos.m_123341_(), bPos.m_123343_());
        int worldCenter = (level.m_141937_() + 2 + height) / 2;
        int n = direction = y > worldCenter ? -1 : 1;
        for (y = bPos.m_123342_(); y >= level.m_141937_() + 2 && y <= level.m_151558_() && !LevelHelper.isRandomizerSafe((Level)level, pos1 = new BlockPos(bPos.m_123341_(), y, bPos.m_123343_())); y += direction) {
        }
        if (!LevelHelper.isRandomizerSafe((Level)level, bPos = new BlockPos(bPos.m_123341_(), y, bPos.m_123343_())) || y <= level.m_141937_() + 2 || y >= level.m_151558_()) {
            return iteration <= 100 ? LevelHelper.getSafePos(LevelHelper.getRandomCoord(level, 25), level, iteration) : bPos;
        }
        level.m_8602_(chunk.m_7697_().f_45578_, chunk.m_7697_().f_45579_, false);
        return bPos;
    }

    public static boolean endHasDragons(ServerLevel level) {
        EndDragonFight fight;
        if (level != null && Level.f_46430_.m_135782_().equals((Object)LevelHelper.getLevelDimensionLocation((Level)level)) && (fight = level.m_8586_()) != null) {
            EndDragonFight.Data data = fight.m_289745_();
            return !data.f_289711_() || data.f_289703_();
        }
        return false;
    }

    public static boolean isRandomizerSafe(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        BlockState aboveState = level.m_8055_(pos.m_7494_());
        BlockState belowState = level.m_8055_(pos.m_7495_());
        if (!(belowState.m_60828_((BlockGetter)level, pos) || belowState.m_60713_(Blocks.f_49991_) || belowState.m_60795_() || belowState.m_60713_(Blocks.f_50576_) || state.m_60828_((BlockGetter)level, pos) || state.m_60713_(Blocks.f_49990_) || state.m_60713_(Blocks.f_49991_) || state.m_60713_(Blocks.f_50576_))) {
            return !aboveState.m_60828_((BlockGetter)level, pos) && !aboveState.m_60713_(Blocks.f_49990_) && !aboveState.m_60713_(Blocks.f_49991_) && !aboveState.m_60713_(Blocks.f_50576_);
        }
        return false;
    }

    public static void teleportEntity(Entity entity, ServerLevel level, BlockPos pos) {
        HashSet<RelativeMovement> relativeSet = new HashSet<RelativeMovement>();
        relativeSet.add(RelativeMovement.Y_ROT);
        entity.m_264318_(level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), relativeSet, entity.m_146908_(), entity.m_146909_());
    }

    public static ResourceLocation getLevelDimensionLocation(Level world) {
        return world.m_46472_().m_135782_();
    }

    public static void playSound(Level world, BlockPos pos, SoundEvent sound, SoundSource category) {
        world.m_5594_(null, pos, sound, category, 100.0f, 1.0f);
    }
}

