/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.client.screen.widget;

import com.jdolphin.ricksportalgun.common.util.PortalGunStyle;
import java.text.DecimalFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class PGSlider
extends AbstractSliderButton {
    protected Component msg;
    protected double minValue;
    protected double maxValue;
    protected double stepSize;
    protected boolean drawString;
    private final DecimalFormat format;
    private boolean renderBG = true;
    private PortalGunStyle style;

    public PGSlider(int x, int y, int width, int height, Component message, double currentValue, double minValue, double maxValue, double stepSize, int precision, boolean drawString) {
        super(x, y, width, height, (Component)Component.m_237119_(), 0.0);
        this.msg = message;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.stepSize = Math.abs(stepSize);
        this.f_93577_ = this.snapToNearest((currentValue - minValue) / (maxValue - minValue));
        this.drawString = drawString;
        if (stepSize == 0.0) {
            precision = Math.min(precision, 4);
            StringBuilder builder = new StringBuilder("0");
            if (precision > 0) {
                builder.append('.');
            }
            while (precision-- > 0) {
                builder.append('0');
            }
            this.format = new DecimalFormat(builder.toString());
        } else {
            this.format = Mth.m_14082_((double)this.stepSize, (double)Math.floor(this.stepSize)) ? new DecimalFormat("0") : new DecimalFormat(Double.toString(this.stepSize).replaceAll("\\d", "0"));
        }
        this.m_5695_();
    }

    public PGSlider(int x, int y, int width, int height, Component message, double currentValue, double minValue, double maxValue, boolean drawString) {
        this(x, y, width, height, message, currentValue, minValue, maxValue, 0.1f, 0, drawString);
    }

    public void setRenderBG(boolean renderBG) {
        this.renderBG = renderBG;
    }

    public void setStyle(PortalGunStyle style) {
        this.style = style;
    }

    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        if (this.renderBG) {
            super.m_87963_(graphics, mouseX, mouseY, delta);
        } else if (this.style != null) {
            graphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, this.style.bgColor());
            graphics.m_280637_(this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_(), this.style.highlightColor());
            int i = this.m_252754_() + (int)(this.f_93577_ * (double)(this.f_93618_ - 8));
            graphics.m_280637_(i, this.m_252907_(), 8, this.m_93694_(), this.style.highlightColor());
            graphics.m_280509_(i, this.m_252907_(), i + 8, this.m_252907_() + this.m_93694_(), this.style.highlightColor());
            int j = this.f_93623_ ? 0xFFFFFF : 0xA0A0A0;
            this.m_280372_(graphics, Minecraft.m_91087_().f_91062_, 2, j | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24);
        }
    }

    public double getValue() {
        return this.f_93577_ * (this.maxValue - this.minValue) + this.minValue;
    }

    public long getValueLong() {
        return Math.round(this.getValue());
    }

    public int getValueInt() {
        return (int)this.getValueLong();
    }

    public void m_93611_(double value) {
        this.f_93577_ = this.snapToNearest((value - this.minValue) / (this.maxValue - this.minValue));
        this.m_5695_();
    }

    public String getValueString() {
        this.format.applyPattern("#.#");
        return this.format.format(this.getValue());
    }

    public void m_5716_(double mouseX, double mouseY) {
        this.m_93585_(mouseX);
    }

    protected void m_7212_(double mouseX, double mouseY, double dragX, double dragY) {
        super.m_7212_(mouseX, mouseY, dragX, dragY);
        this.m_93585_(mouseX);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        boolean flag;
        boolean bl = flag = keyCode == 263;
        if (flag || keyCode == 262) {
            float f;
            if (this.minValue > this.maxValue) {
                flag = !flag;
            }
            float f2 = f = flag ? -1.0f : 1.0f;
            if (this.stepSize <= 0.0) {
                this.setSliderValue(this.f_93577_ + (double)(f / (float)(this.f_93618_ - 8)));
            } else {
                this.m_93611_(this.getValue() + (double)f * this.stepSize);
            }
        }
        return false;
    }

    private void m_93585_(double mouseX) {
        this.setSliderValue((mouseX - (double)(this.m_252754_() + 4)) / (double)(this.f_93618_ - 8));
    }

    private void setSliderValue(double value) {
        double oldValue = this.f_93577_;
        this.f_93577_ = this.snapToNearest(value);
        if (!Mth.m_14082_((double)oldValue, (double)this.f_93577_)) {
            this.m_5697_();
        }
        this.m_5695_();
    }

    private double snapToNearest(double value) {
        if (this.stepSize <= 0.0) {
            return Mth.m_14008_((double)value, (double)0.0, (double)1.0);
        }
        value = Mth.m_14139_((double)Mth.m_14008_((double)value, (double)0.0, (double)1.0), (double)this.minValue, (double)this.maxValue);
        value = this.stepSize * (double)Math.round(value / this.stepSize);
        value = this.minValue > this.maxValue ? Mth.m_14008_((double)value, (double)this.maxValue, (double)this.minValue) : Mth.m_14008_((double)value, (double)this.minValue, (double)this.maxValue);
        return Mth.m_144914_((double)value, (double)this.minValue, (double)this.maxValue, (double)0.0, (double)1.0);
    }

    protected void m_5695_() {
        if (this.drawString) {
            this.m_93666_((Component)Component.m_237119_().m_7220_(this.msg).m_130946_(this.getValueString()));
        } else {
            this.m_93666_((Component)Component.m_237119_());
        }
    }

    protected void m_5697_() {
    }
}

