/*
 * Decompiled with CFR 0.152.
 */
package com.theendercore.block_beams;

import com.theendercore.block_beams.BlockBeams;
import com.theendercore.block_beams.BlockCheckType;
import com.theendercore.block_beams.Config;
import com.theendercore.block_beams.ConfigData;
import java.awt.Color;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_702;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001f\u0010\u000f\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J'\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001f\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001f\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cR \u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00130\u001d8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001e0!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#\u00a8\u0006$"}, d2={"Lcom/theendercore/block_beams/BeamControl;", "", "<init>", "()V", "Lnet/minecraft/class_2680;", "state", "Lnet/minecraft/class_1937;", "world", "Lnet/minecraft/class_2338;", "pos", "", "spawn", "(Lnet/minecraft/class_2680;Lnet/minecraft/class_1937;Lnet/minecraft/class_2338;)V", "", "color", "particles", "(Lnet/minecraft/class_2338;Ljava/lang/String;)V", "", "dist", "", "canPassable", "(Lnet/minecraft/class_1937;Lnet/minecraft/class_2338;I)Z", "Lcom/theendercore/block_beams/ConfigData;", "c", "clientOnlyCheck", "(Lnet/minecraft/class_2680;Lcom/theendercore/block_beams/ConfigData;)Z", "id", "checkBlock", "(Lnet/minecraft/class_2680;Ljava/lang/String;)Z", "", "Lnet/minecraft/class_2248;", "CLIENT_CACHE", "Ljava/util/Map;", "Lnet/minecraft/class_6862;", "PASSABLE_BLOCKS", "Lnet/minecraft/class_6862;", "block_beams"})
public final class BeamControl {
    @NotNull
    public static final BeamControl INSTANCE = new BeamControl();
    @NotNull
    private static final Map<class_2248, Boolean> CLIENT_CACHE = new LinkedHashMap();
    @NotNull
    private static final class_6862<class_2248> PASSABLE_BLOCKS;

    private BeamControl() {
    }

    @JvmStatic
    public static final void spawn(@NotNull class_2680 state, @NotNull class_1937 world, @NotNull class_2338 pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Map<class_2960, String> map = Config.INSTANCE.getParsedMap();
        class_2248 class_22482 = state.method_26204();
        Intrinsics.checkNotNullExpressionValue((Object)class_22482, (String)"getBlock(...)");
        String string = map.get(BlockBeams.INSTANCE.getId(class_22482));
        if (string == null) {
            return;
        }
        String color = string;
        for (int i = 1; i < 4; ++i) {
            if (INSTANCE.canPassable(world, pos, i)) continue;
            return;
        }
        INSTANCE.particles(pos, color);
    }

    private final void particles(class_2338 pos, String color) {
        int n = 12;
        for (int i = 0; i < n; ++i) {
            int i2 = i;
            boolean bl = false;
            try {
                class_702 class_7022 = class_310.method_1551().field_1713;
                class_2394 class_23942 = (class_2394)new class_2390(Color.decode(color).getRGB(), 1.0f);
                int n2 = pos.method_10263();
                int n3 = 1;
                int n4 = n2 / n3;
                if ((n2 ^ n3) < 0 && n4 * n3 != n2) {
                    --n4;
                }
                double d = (double)n4 + 0.5;
                double d2 = (double)pos.method_10264() + 1.2 + 0.25 * (double)i2;
                n2 = pos.method_10260();
                n3 = 1;
                n4 = n2 / n3;
                if ((n2 ^ n3) < 0 && n4 * n3 != n2) {
                    --n4;
                }
                class_7022.method_3056(class_23942, d, d2, (double)n4 + 0.5, 0.0, 10.0, 0.0);
                continue;
            }
            catch (Throwable throwable) {
                BlockBeams.INSTANCE.getLog().warn("Could not spawn particle effect");
            }
        }
    }

    private final boolean canPassable(class_1937 world, class_2338 pos, int dist) {
        class_2680 state = world.method_8320(pos.method_10086(dist));
        return switch (WhenMappings.$EnumSwitchMapping$0[Config.INSTANCE.getData().getBlockCheckType().ordinal()]) {
            case 1 -> {
                Intrinsics.checkNotNull((Object)state);
                yield this.clientOnlyCheck(state, Config.INSTANCE.getData());
            }
            case 2 -> state.method_26164(PASSABLE_BLOCKS);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final boolean clientOnlyCheck(class_2680 state, ConfigData c) {
        for (String id : c.getClientTag()) {
            Boolean cached = CLIENT_CACHE.get(state.method_26204());
            if (cached == null) {
                cached = this.checkBlock(state, id);
                CLIENT_CACHE.put(state.method_26204(), cached);
            }
            if (!cached.booleanValue()) continue;
            return true;
        }
        return false;
    }

    private final boolean checkBlock(class_2680 state, String id) {
        boolean bl;
        if (StringsKt.startsWith$default((String)id, (String)"#", (boolean)false, (int)2, null)) {
            bl = state.method_26164(class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)BlockBeams.INSTANCE.parseId(StringsKt.removePrefix((String)id, (CharSequence)"#"))));
        } else {
            class_2248 class_22482 = state.method_26204();
            Intrinsics.checkNotNullExpressionValue((Object)class_22482, (String)"getBlock(...)");
            bl = Intrinsics.areEqual((Object)BlockBeams.INSTANCE.getId(class_22482), (Object)BlockBeams.INSTANCE.parseId(id));
        }
        return bl;
    }

    static {
        class_6862 class_68622 = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)BlockBeams.INSTANCE.id("passable_blocks"));
        Intrinsics.checkNotNullExpressionValue((Object)class_68622, (String)"create(...)");
        PASSABLE_BLOCKS = class_68622;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BlockCheckType.values().length];
            try {
                nArray[BlockCheckType.CLIENT_ONLY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockCheckType.SERVER_ONLY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

