/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.translater.transformer;

import io.gitlab.jfronny.translater.Cfg;
import io.gitlab.jfronny.translater.RenderScheduler;
import io.gitlab.jfronny.translater.Translater;
import io.gitlab.jfronny.translater.transformer.Transformer;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class TransformingMap
implements Map<String, String> {
    private final Transformer transformer;
    private final RenderScheduler renderScheduler = new RenderScheduler();
    private Map<String, String> backer = null;
    public boolean initializing = false;
    private AtomicInteger initProgress = null;
    private int maxProgress = 0;

    public TransformingMap(Transformer t) {
        this.transformer = t;
    }

    public void updateBacker(Map<String, String> backer) {
        if (this.backer != backer) {
            this.backer = backer;
            Collection<String> strings = backer.values();
            this.initializing = true;
            this.generateTranslations(strings);
            this.initializing = false;
        }
    }

    private void generateTranslations(Collection<? extends String> strings) {
        this.maxProgress = strings.size();
        this.initProgress = new AtomicInteger();
        this.transformer.transformMultiple(strings.parallelStream(), (str, translation) -> {
            int i = this.initProgress.incrementAndGet();
            if (i % 10 == 0 || Cfg.detailedProgress) {
                if (Cfg.progressConsole) {
                    Translater.LOGGER.info("{0}", new Object[]{this.getInitProgress()});
                }
                if (Cfg.progressGui && i % 10 == 0) {
                    this.renderScheduler.scheduleRender();
                }
            }
        });
        this.renderScheduler.deschedule();
        this.initProgress = null;
    }

    public String getInitProgress() {
        if (this.initProgress == null || !this.initializing) {
            throw new IllegalStateException("Tried to get init progress while not initializing");
        }
        return "Transforming %d/%d".formatted(this.initProgress.get(), this.maxProgress);
    }

    @Override
    public int size() {
        return this.backer.size();
    }

    @Override
    public boolean isEmpty() {
        return this.backer.isEmpty();
    }

    @Override
    public boolean containsKey(Object o) {
        return this.backer.containsKey(o);
    }

    @Override
    public boolean containsValue(Object o) {
        return this.backer.containsValue(o);
    }

    @Override
    public String get(Object o) {
        String s;
        if (o instanceof String && (s = (String)o).startsWith("translater.")) {
            return this.backer.get(s);
        }
        return this.transformer.transform(this.backer.get(o));
    }

    @Override
    public String put(String s, String s2) {
        this.transformer.transform(s2);
        return this.backer.put(s, s2);
    }

    @Override
    public String remove(Object o) {
        return this.backer.remove(o);
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> map) {
        this.generateTranslations(map.values());
        this.backer.putAll(map);
    }

    @Override
    public void clear() {
        this.backer.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.backer.keySet();
    }

    @Override
    public Collection<String> values() {
        return this.backer.values();
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.backer.entrySet();
    }
}

