/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.translater;

import io.gitlab.jfronny.libjf.config.api.v2.dsl.ConfigBuilder;
import io.gitlab.jfronny.libjf.config.api.v2.dsl.Migration;
import io.gitlab.jfronny.translater.Cfg;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class CfgMigration {
    public static ConfigBuilder<?> tweak(ConfigBuilder<?> cb) {
        return (ConfigBuilder)cb.addMigration("renderProgress", Migration.of(reader -> {
            String renderMode = reader.nextString();
            if (renderMode == null) {
                return;
            }
            switch (renderMode.toLowerCase()) {
                case "full": {
                    Cfg.detailedProgress = true;
                    Cfg.progressConsole = true;
                    Cfg.progressGui = true;
                    break;
                }
                case "gui": {
                    Cfg.detailedProgress = false;
                    Cfg.progressConsole = false;
                    Cfg.progressGui = true;
                    break;
                }
                case "console": {
                    Cfg.detailedProgress = false;
                    Cfg.progressGui = false;
                    Cfg.progressConsole = true;
                    break;
                }
                case "none": {
                    Cfg.detailedProgress = false;
                    Cfg.progressConsole = false;
                    Cfg.progressGui = false;
                }
            }
        }));
    }
}

