/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.translater;

import io.gitlab.jfronny.commons.logger.SystemLoggerPlus;
import io.gitlab.jfronny.libjf.translate.api.TranslateService;
import io.gitlab.jfronny.translater.transformer.CachingTransformer;
import io.gitlab.jfronny.translater.transformer.FailTransformer;
import io.gitlab.jfronny.translater.transformer.TransformingMap;
import io.gitlab.jfronny.translater.transformer.TranslatingTransformer;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class Translater {
    public static final String MOD_ID = "translater";
    public static final SystemLoggerPlus LOGGER = SystemLoggerPlus.forName((String)"translater");
    private static final TransformingMap map;

    @NotNull
    public static TransformingMap getMap(@Nullable Map<String, String> base) {
        if (base != null) {
            map.updateBacker(base);
        }
        return map;
    }

    static {
        TranslateService ts = TranslateService.getConfigured();
        if (ts == null || ts.getName().equals("Noop")) {
            LOGGER.error("No translation service found! Please configure a translation service in the libjf-translate config and restart the game!\nThis means NO NEW TRANSLATIONS WILL BE GENERATED!", new Object[0]);
            map = new TransformingMap(new CachingTransformer(new FailTransformer()));
        } else {
            map = new TransformingMap(new CachingTransformer(new TranslatingTransformer(ts)));
        }
    }
}

