/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.translater.transformer;

import io.gitlab.jfronny.commons.concurrent.AsyncRequestState;
import io.gitlab.jfronny.libjf.config.api.v2.ConfigHolder;
import io.gitlab.jfronny.libjf.config.api.v2.ConfigInstance;
import io.gitlab.jfronny.translater.Cfg;
import io.gitlab.jfronny.translater.Translater;
import io.gitlab.jfronny.translater.transformer.Transformer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class CachingTransformer
implements Transformer {
    private static final Path CACHE_FILE = FabricLoader.getInstance().getConfigDir().resolve("translater.cache");
    @Nullable
    private final Properties defaultCache;
    private final Properties cache = new Properties();
    private final Transformer transformer;
    private final AsyncRequestState state = new AsyncRequestState();

    @Override
    public String transform(String str) {
        if (str == null) {
            return null;
        }
        if (!this.cache.containsKey(str)) {
            if (this.defaultCache != null && this.defaultCache.containsKey(str)) {
                return (String)this.defaultCache.get(str);
            }
            String transformed = this.transformer.transform(str);
            if (transformed == null) {
                return str;
            }
            this.cache.put(str, transformed);
            this.scheduleSave();
        }
        return (String)this.cache.get(str);
    }

    @Override
    public void transformMultiple(Stream<? extends String> strings, Transformer.ResultConsumer results) {
        AtomicInteger count = new AtomicInteger(0);
        this.transformer.transformMultiple(strings.filter(s -> {
            String translation = (String)this.cache.get(s);
            if (translation != null) {
                results.accept((String)s, translation);
                return false;
            }
            if (this.defaultCache != null && (translation = (String)this.defaultCache.get(s)) != null) {
                results.accept((String)s, translation);
                return false;
            }
            return true;
        }), (str, translation) -> {
            this.cache.put(str, translation);
            results.accept(str, translation);
            if (count.incrementAndGet() == 50) {
                count.addAndGet(-50);
                this.scheduleSave();
            }
        });
        if (count.get() > 0) {
            this.scheduleSave();
        }
    }

    public CachingTransformer(Transformer baseTransformer) {
        this.transformer = baseTransformer;
        if (Cfg.forceRegenerate) {
            Cfg.forceRegenerate = false;
            ((ConfigInstance)ConfigHolder.getInstance().getRegistered().get("translater")).write();
        } else if (Files.exists(CACHE_FILE, new LinkOption[0]) && Files.isRegularFile(CACHE_FILE, new LinkOption[0])) {
            Translater.LOGGER.info("Loading cache", new Object[0]);
            try (InputStream inS = Files.newInputStream(CACHE_FILE, new OpenOption[0]);){
                this.cache.load(inS);
            }
            catch (IOException e) {
                Translater.LOGGER.error("Could not load translater cache", (Throwable)e);
            }
        }
        if (Cfg.useDefaultCache && !Cfg.breakFully && Cfg.rounds == 5 && "en".equals(Cfg.targetLanguage) && !Cfg.forceRegenerate) {
            Translater.LOGGER.info("Initializing default cache", new Object[0]);
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Properties p = new Properties();
            try (InputStream inS = classLoader.getResourceAsStream("namecache.ini");){
                if (inS == null) {
                    p = null;
                } else {
                    p.load(inS);
                }
            }
            catch (IOException e) {
                p = null;
                Translater.LOGGER.error("Could not initialize default translater cache", (Throwable)e);
            }
            this.defaultCache = p;
        } else {
            this.defaultCache = null;
        }
        this.scheduleSave();
    }

    private void scheduleSave() {
        if (this.state.request().shouldStart()) {
            do {
                if (this.cache.isEmpty()) continue;
                try (OutputStream outS = Files.newOutputStream(CACHE_FILE, new OpenOption[0]);){
                    this.cache.store(outS, "---Lang---");
                }
                catch (IOException e) {
                    Translater.LOGGER.error("Could not save translater cache", new Object[0]);
                }
            } while (this.state.emitFinished().shouldContinue());
        }
    }
}

