/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.translater.transformer;

import io.gitlab.jfronny.libjf.translate.api.Language;
import io.gitlab.jfronny.libjf.translate.api.TranslateException;
import io.gitlab.jfronny.libjf.translate.api.TranslateService;
import io.gitlab.jfronny.translater.Cfg;
import io.gitlab.jfronny.translater.Translater;
import io.gitlab.jfronny.translater.transformer.Transformer;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.apache.commons.lang3.StringUtils;

@Environment(value=EnvType.CLIENT)
public class TranslatingTransformer<T extends Language>
implements Transformer {
    private static final Pattern SURROUNDING_SPACE_PATTERN = Pattern.compile("^(\\s*)(.*\\S+)(\\s*)$", 8);
    private final Random rnd = new Random();
    private final TranslateService<T> ts;
    private final List<T> languages;
    private final T languageAuto;
    private final T languageEnglish;

    public TranslatingTransformer(TranslateService<T> ts) {
        this.ts = ts;
        this.languages = ts.getAvailableLanguages();
        this.languageAuto = ts.parseLang("auto");
        this.languageEnglish = ts.parseLang("en");
    }

    @Override
    public String transform(String str) {
        try {
            return this.tryTransform(str);
        }
        catch (Exception e) {
            Translater.LOGGER.warn("Failed to transform: \"{0}\" ({1} characters)! Please report this bug with the mod containing the lang file!", (Throwable)e, new Object[]{str, str.length()});
            return null;
        }
    }

    private String tryTransform(String str) throws TranslateException {
        if (str.contains("%")) {
            StringBuilder res = new StringBuilder();
            boolean f = true;
            for (String s : str.split("%")) {
                if (!f) {
                    res.append("%");
                    if (!s.isEmpty()) {
                        this.appendTransformed(res.append(s.charAt(0)), s.substring(1), x -> x.replace("%", ""));
                    }
                } else {
                    this.appendTransformed(res, s, Function.identity());
                }
                f = false;
            }
            return res.toString();
        }
        if (str.contains("$")) {
            StringBuilder res = new StringBuilder();
            boolean f = true;
            for (String s : str.split("\\$")) {
                if (f) {
                    this.appendTransformed(res, s, Function.identity());
                } else {
                    this.appendTransformed(res.append("$").append(s.charAt(0)), s.substring(1), x -> x.replace("$", ""));
                }
                f = false;
            }
            return res.toString();
        }
        if (str.contains("\u00a7")) {
            StringBuilder res = new StringBuilder();
            boolean f = true;
            for (String s : str.split("\u00a7")) {
                if (f) {
                    this.appendTransformed(res, s, Function.identity());
                } else {
                    this.appendTransformed(res.append("\u00a7").append(s.charAt(0)), s.substring(1), x -> x.replace("\u00a7", ""));
                }
                f = false;
            }
            return res.toString();
        }
        return this.translateMultiple(str);
    }

    private void appendTransformed(StringBuilder sb, String transformable, Function<String, String> fix) throws TranslateException {
        if (transformable.isEmpty()) {
            return;
        }
        sb.append(fix.apply(this.tryTransform(transformable)));
    }

    @Override
    public void transformMultiple(Stream<? extends String> strings, Transformer.ResultConsumer results) {
        strings.flatMap(s -> {
            try {
                return Stream.of(new Translation((String)s, this.tryTransform((String)s)));
            }
            catch (Exception e) {
                System.exit(0);
                return Stream.empty();
            }
        }).forEach(t -> results.accept(t.from, t.to));
    }

    private String translateMultiple(String str) throws TranslateException {
        Matcher m = SURROUNDING_SPACE_PATTERN.matcher(str);
        if (!m.find()) {
            if (Cfg.detailedProgress) {
                Translater.LOGGER.info("Skipping translation of \"{0}\"", new Object[]{str});
            }
            return str;
        }
        try {
            T startLang = StringUtils.isAlpha((CharSequence)Cfg.targetLanguage) && Cfg.targetLanguage.length() == 2 ? this.ts.parseLang(Cfg.targetLanguage) : this.languageAuto;
            Object currentState = m.group(2);
            T currentLang = startLang;
            for (int i = 0; i < Cfg.rounds; ++i) {
                T newLang = this.randomLanguage();
                currentState = this.ts.translate((String)currentState, Cfg.breakFully ? this.randomLanguage() : currentLang, newLang);
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                currentLang = newLang;
            }
            currentState = this.ts.translate((String)currentState, currentLang, startLang == this.languageAuto ? this.languageEnglish : startLang);
            currentState = m.group(1) + (String)currentState + m.group(3);
            if (Cfg.detailedProgress) {
                Translater.LOGGER.info("Transformed: \"{0}\" to: \"{1}\"", new Object[]{str, currentState});
            }
            return currentState;
        }
        catch (Exception e) {
            String s = m.group(2);
            Translater.LOGGER.warn("Failed to break: \"{0}\" ({1} characters). Is your API key valid?", (Throwable)e, new Object[]{s, s.length()});
            throw e;
        }
    }

    private T randomLanguage() {
        return (T)((Language)this.languages.get(this.rnd.nextInt(this.languages.size())));
    }

    @Environment(value=EnvType.CLIENT)
    private record Translation(String from, String to) {
    }
}

