/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.collectibles.integration;

import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiInfoRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import xxrexraptorxx.collectibles.main.Collectibles;
import xxrexraptorxx.collectibles.registry.ModItems;
import xxrexraptorxx.collectibles.utils.CollectibleHelper;
import xxrexraptorxx.collectibles.utils.Config;
import xxrexraptorxx.magmacore.utils.FormattingHelper;

@EmiEntrypoint
public class EMIIntegration
implements EmiPlugin {
    public void register(EmiRegistry registry) {
        ArrayList treasures = new ArrayList();
        ArrayList<EmiStack> epic_treasures = new ArrayList<EmiStack>();
        for (String item : Config.getEpicLootBagRewards()) {
            try {
                epic_treasures.add(EmiStack.of((ItemStack)CollectibleHelper.parseItemEntry(item)));
            }
            catch (Exception e) {
                Collectibles.LOGGER.error("Invalid item entry '{}' in epic_loot_bag_rewards config: {}", (Object)item, (Object)e.getMessage());
            }
        }
        for (String item : Config.getLootBagRewards()) {
            try {
                epic_treasures.add(EmiStack.of((ItemStack)CollectibleHelper.parseItemEntry(item)));
            }
            catch (Exception e) {
                Collectibles.LOGGER.error("Invalid item entry '{}' in epic_loot_bag_rewards config: {}", (Object)item, (Object)e.getMessage());
            }
        }
        registry.addRecipe((EmiRecipe)new EmiInfoRecipe(treasures, List.of(FormattingHelper.setModLangComponent((String)"message", (String)"collectibles", (String)"lootbag_jei_desc")), ResourceLocation.fromNamespaceAndPath((String)"collectibles", (String)"info/lootbag_treasures")));
        registry.addRecipe((EmiRecipe)new EmiInfoRecipe(epic_treasures, List.of(FormattingHelper.setModLangComponent((String)"message", (String)"collectibles", (String)"epic_lootbag_jei_desc")), ResourceLocation.fromNamespaceAndPath((String)"collectibles", (String)"info/epic_lootbag_treasures")));
        registry.addRecipe((EmiRecipe)new EmiInfoRecipe(List.of(EmiStack.of(ModItems.LOOT_BAG), EmiStack.of(ModItems.EPIC_LOOT_BAG)), List.of(FormattingHelper.setModLangComponent((String)"message", (String)"collectibles", (String)"lootbag_jei_desc")), ResourceLocation.fromNamespaceAndPath((String)"collectibles", (String)"info/bag")));
    }
}

