/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.collectibles.integration;

import java.util.ArrayList;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import xxrexraptorxx.collectibles.main.Collectibles;
import xxrexraptorxx.collectibles.registry.ModItems;
import xxrexraptorxx.collectibles.utils.CollectibleHelper;
import xxrexraptorxx.collectibles.utils.Config;
import xxrexraptorxx.magmacore.utils.FormattingHelper;

@JeiPlugin
public class JEIIntegration
implements IModPlugin {
    private static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"collectibles", (String)"jei_plugin");

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerRecipes(IRecipeRegistration registry) {
        ArrayList<ItemStack> treasures = new ArrayList<ItemStack>();
        ArrayList<ItemStack> epic_treasures = new ArrayList<ItemStack>();
        for (String item : Config.getEpicLootBagRewards()) {
            try {
                epic_treasures.add(CollectibleHelper.parseItemEntry(item));
            }
            catch (Exception e) {
                Collectibles.LOGGER.error("Invalid item entry '{}' in epic_loot_bag_rewards config: {}", (Object)item, (Object)e.getMessage());
            }
        }
        for (String item : Config.getLootBagRewards()) {
            try {
                treasures.add(CollectibleHelper.parseItemEntry(item));
            }
            catch (Exception e) {
                Collectibles.LOGGER.error("Invalid item entry '{}' in epic_loot_bag_rewards config: {}", (Object)item, (Object)e.getMessage());
            }
        }
        registry.addIngredientInfo(treasures, (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{FormattingHelper.setModLangComponent((String)"message", (String)"collectibles", (String)"lootbag_entry_jei_desc")});
        registry.addIngredientInfo(epic_treasures, (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{FormattingHelper.setModLangComponent((String)"message", (String)"collectibles", (String)"epic_lootbag_entry_jei_desc")});
        registry.addIngredientInfo((Object)new ItemStack((ItemLike)ModItems.LOOT_BAG.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{FormattingHelper.setModLangComponent((String)"message", (String)"collectibles", (String)"lootbag_jei_desc")});
        registry.addIngredientInfo((Object)new ItemStack((ItemLike)ModItems.EPIC_LOOT_BAG.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{FormattingHelper.setModLangComponent((String)"message", (String)"collectibles", (String)"lootbag_jei_desc")});
    }
}

