/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.collectibles.integration;

import java.util.ArrayList;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.forge.REIPluginClient;
import me.shedaniel.rei.plugin.client.BuiltinClientPlugin;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import xxrexraptorxx.collectibles.main.Collectibles;
import xxrexraptorxx.collectibles.registry.ModItems;
import xxrexraptorxx.collectibles.utils.CollectibleHelper;
import xxrexraptorxx.collectibles.utils.Config;
import xxrexraptorxx.magmacore.utils.FormattingHelper;

@REIPluginClient
public class REIIntegration
implements REIClientPlugin {
    public void registerDisplays(DisplayRegistry registry) {
        BuiltinClientPlugin instance = BuiltinClientPlugin.getInstance();
        ArrayList<EntryStack> treasures = new ArrayList<EntryStack>();
        ArrayList<EntryStack> epic_treasures = new ArrayList<EntryStack>();
        for (String item : Config.getEpicLootBagRewards()) {
            try {
                epic_treasures.add(EntryStacks.of((ItemStack)CollectibleHelper.parseItemEntry(item)));
            }
            catch (Exception e) {
                Collectibles.LOGGER.error("Invalid item entry '{}' in epic_loot_bag_rewards config: {}", (Object)item, (Object)e.getMessage());
            }
        }
        for (String item : Config.getLootBagRewards()) {
            try {
                treasures.add(EntryStacks.of((ItemStack)CollectibleHelper.parseItemEntry(item)));
            }
            catch (Exception e) {
                Collectibles.LOGGER.error("Invalid item entry '{}' in epic_loot_bag_rewards config: {}", (Object)item, (Object)e.getMessage());
            }
        }
        instance.registerInformation(EntryIngredient.of(treasures), (Component)Component.empty(), list -> {
            list.add(FormattingHelper.setModLangComponent((String)"message", (String)"collectibles", (String)"lootbag_entry_jei_desc"));
            return list;
        });
        instance.registerInformation(EntryIngredient.of(epic_treasures), (Component)Component.empty(), list -> {
            list.add(FormattingHelper.setModLangComponent((String)"message", (String)"collectibles", (String)"epic_lootbag_entry_jei_desc"));
            return list;
        });
        instance.registerInformation(EntryStacks.of(ModItems.LOOT_BAG), (Component)Component.empty(), list -> {
            list.add(FormattingHelper.setModLangComponent((String)"message", (String)"collectibles", (String)"lootbag_jei_desc"));
            return list;
        });
        instance.registerInformation(EntryStacks.of(ModItems.EPIC_LOOT_BAG), (Component)Component.empty(), list -> {
            list.add(FormattingHelper.setModLangComponent((String)"message", (String)"collectibles", (String)"lootbag_jei_desc"));
            return list;
        });
    }
}

