/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.collectibles.utils;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import xxrexraptorxx.collectibles.main.Collectibles;
import xxrexraptorxx.collectibles.registry.ModItems;
import xxrexraptorxx.collectibles.registry.ModStats;
import xxrexraptorxx.collectibles.utils.CollectibleSet;
import xxrexraptorxx.collectibles.utils.Config;

public class CollectibleHelper {
    public static ItemStack getRandomTreasure() {
        ArrayList<ItemStack> rewards = new ArrayList<ItemStack>();
        Random random = new Random();
        for (String item : Config.getLootBagRewards()) {
            try {
                rewards.add(new ItemStack((ItemLike)BuiltInRegistries.ITEM.getValue(ResourceLocation.fromNamespaceAndPath((String)item.substring(item.indexOf(42) + 1, item.indexOf(58)), (String)item.substring(item.indexOf(58) + 1))), Integer.parseInt(item.substring(0, item.indexOf(42)))));
            }
            catch (Exception e) {
                Collectibles.LOGGER.error("Invalid item entry in the Collectibles 'loot_bag_rewards' config option!");
            }
        }
        return (ItemStack)rewards.get(random.nextInt(rewards.size()));
    }

    public static ItemStack getRandomEpicTreasure() {
        ArrayList<ItemStack> rewards = new ArrayList<ItemStack>();
        Random random = new Random();
        for (String item : Config.getEpicLootBagRewards()) {
            try {
                rewards.add(new ItemStack((ItemLike)BuiltInRegistries.ITEM.getValue(ResourceLocation.fromNamespaceAndPath((String)item.substring(item.indexOf(42) + 1, item.indexOf(58)), (String)item.substring(item.indexOf(58) + 1))), Integer.parseInt(item.substring(0, item.indexOf(42)))));
            }
            catch (Exception e) {
                Collectibles.LOGGER.error("Invalid item entry in the Collectibles 'epic_loot_bag_rewards' config option!");
            }
        }
        return (ItemStack)rewards.get(random.nextInt(rewards.size()));
    }

    public static ItemStack getRandomCollectible(CollectibleSet set) {
        switch (set) {
            case COIN_SET: {
                CollectibleHelper.getRandomCoin();
            }
            case FRAGMENT_SET: {
                CollectibleHelper.getRandomFragment();
            }
            case FOSSIL_SET: {
                CollectibleHelper.getRandomFossil();
            }
        }
        Collectibles.LOGGER.error("Unknown Collectible Set!");
        return new ItemStack((ItemLike)Items.AIR);
    }

    public static ItemStack getRandomCoin() {
        Random random = new Random();
        return switch (random.nextInt(9)) {
            case 0 -> new ItemStack((ItemLike)ModItems.COPPER_COIN.get());
            case 1 -> new ItemStack((ItemLike)ModItems.NETHERITE_COIN.get());
            case 2 -> new ItemStack((ItemLike)ModItems.SILVER_COIN.get());
            case 3 -> new ItemStack((ItemLike)ModItems.IRON_COIN.get());
            case 4 -> new ItemStack((ItemLike)ModItems.BRASS_COIN.get());
            case 5 -> new ItemStack((ItemLike)ModItems.BRONZE_COIN.get());
            case 6 -> new ItemStack((ItemLike)ModItems.GOLD_COIN.get());
            case 7 -> new ItemStack((ItemLike)ModItems.PLATINUM_COIN.get());
            case 8 -> new ItemStack((ItemLike)ModItems.STONE_COIN.get());
            default -> new ItemStack((ItemLike)Items.AIR);
        };
    }

    public static ItemStack getRandomFragment() {
        Random random = new Random();
        return switch (random.nextInt(9)) {
            case 0 -> new ItemStack((ItemLike)ModItems.AMETHYST_FRAGMENT.get());
            case 1 -> new ItemStack((ItemLike)ModItems.DIAMOND_FRAGMENT.get());
            case 2 -> new ItemStack((ItemLike)ModItems.EMERALD_FRAGMENT.get());
            case 3 -> new ItemStack((ItemLike)ModItems.RUBY_FRAGMENT.get());
            case 4 -> new ItemStack((ItemLike)ModItems.SAPPHIRE_FRAGMENT.get());
            case 5 -> new ItemStack((ItemLike)ModItems.CRYSTAL_FRAGMENT.get());
            case 6 -> new ItemStack((ItemLike)ModItems.TOPAZ_FRAGMENT.get());
            case 7 -> new ItemStack((ItemLike)ModItems.HEMATITE_FRAGMENT.get());
            case 8 -> new ItemStack((ItemLike)ModItems.TOURMALINE_FRAGMENT.get());
            default -> new ItemStack((ItemLike)Items.AIR);
        };
    }

    public static ItemStack getRandomFossil() {
        Random random = new Random();
        return switch (random.nextInt(9)) {
            case 0 -> new ItemStack((ItemLike)ModItems.CLAW_FOSSIL.get());
            case 1 -> new ItemStack((ItemLike)ModItems.LEG_FOSSIL.get());
            case 2 -> new ItemStack((ItemLike)ModItems.AMMONITE_FOSSIL.get());
            case 3 -> new ItemStack((ItemLike)ModItems.CRINOID_FOSSIL.get());
            case 4 -> new ItemStack((ItemLike)ModItems.TRILOBITE_FOSSIL.get());
            case 5 -> new ItemStack((ItemLike)ModItems.SKULL_FOSSIL.get());
            case 6 -> new ItemStack((ItemLike)ModItems.SPINE_FOSSIL.get());
            case 7 -> new ItemStack((ItemLike)ModItems.RIP_FOSSIL.get());
            case 8 -> new ItemStack((ItemLike)ModItems.THORAX_FOSSIL.get());
            default -> new ItemStack((ItemLike)Items.AIR);
        };
    }

    public static ItemStack getRandomLeave() {
        Random random = new Random();
        return switch (random.nextInt(9)) {
            case 0 -> new ItemStack((ItemLike)ModItems.DELICIOSA_LEAVE.get());
            case 1 -> new ItemStack((ItemLike)ModItems.AUREA_LEAVE.get());
            case 2 -> new ItemStack((ItemLike)ModItems.OBLIQUA_LEAVE.get());
            case 3 -> new ItemStack((ItemLike)ModItems.SUBPINNATA_LEAVE.get());
            case 4 -> new ItemStack((ItemLike)ModItems.FRYDEK_LEAVE.get());
            case 5 -> new ItemStack((ItemLike)ModItems.JACKLYN_LEAVE.get());
            case 6 -> new ItemStack((ItemLike)ModItems.SABRINA_LEAVE.get());
            case 7 -> new ItemStack((ItemLike)ModItems.FLORIDA_LEAVE.get());
            case 8 -> new ItemStack((ItemLike)ModItems.BILLIETIAE_LEAVE.get());
            default -> new ItemStack((ItemLike)Items.AIR);
        };
    }

    public static Integer getCollectibleNumber(ItemStack collectible) {
        Item item = collectible.getItem();
        if (item == ModItems.GOLD_COIN.get() || item == ModItems.DIAMOND_FRAGMENT.get() || item == ModItems.OLD_BOOK.get() || item == ModItems.CLAW_FOSSIL.get() || item == ModItems.AMULET_JEWELRY.get() || item == ModItems.DELICIOSA_LEAVE.get()) {
            return 1;
        }
        if (item == ModItems.SILVER_COIN.get() || item == ModItems.EMERALD_FRAGMENT.get() || item == ModItems.NECRONOMICON_BOOK.get() || item == ModItems.LEG_FOSSIL.get() || item == ModItems.HAIRPIN_JEWELRY.get() || item == ModItems.AUREA_LEAVE.get()) {
            return 2;
        }
        if (item == ModItems.PLATINUM_COIN.get() || item == ModItems.AMETHYST_FRAGMENT.get() || item == ModItems.KNOWLEDGE_BOOK.get() || item == ModItems.AMMONITE_FOSSIL.get() || item == ModItems.BRACELET_JEWELRY.get() || item == ModItems.OBLIQUA_LEAVE.get()) {
            return 3;
        }
        if (item == ModItems.NETHERITE_COIN.get() || item == ModItems.RUBY_FRAGMENT.get() || item == ModItems.NOTCHS_BOOK.get() || item == ModItems.CRINOID_FOSSIL.get() || item == ModItems.BROOCH_JEWELRY.get() || item == ModItems.SUBPINNATA_LEAVE.get()) {
            return 4;
        }
        if (item == ModItems.COPPER_COIN.get() || item == ModItems.SAPPHIRE_FRAGMENT.get() || item == ModItems.DARKHOLD_BOOK.get() || item == ModItems.TRILOBITE_FOSSIL.get() || item == ModItems.EARRING_JEWELRY.get() || item == ModItems.FRYDEK_LEAVE.get()) {
            return 5;
        }
        if (item == ModItems.BRONZE_COIN.get() || item == ModItems.TOPAZ_FRAGMENT.get() || item == ModItems.MONSTER_BOOK.get() || item == ModItems.SKULL_FOSSIL.get() || item == ModItems.DIADEM_JEWELRY.get() || item == ModItems.JACKLYN_LEAVE.get()) {
            return 6;
        }
        if (item == ModItems.BRASS_COIN.get() || item == ModItems.CRYSTAL_FRAGMENT.get() || item == ModItems.GRIMOIRE_BOOK.get() || item == ModItems.SPINE_FOSSIL.get() || item == ModItems.CROWN_JEWELRY.get() || item == ModItems.SABRINA_LEAVE.get()) {
            return 7;
        }
        if (item == ModItems.IRON_COIN.get() || item == ModItems.HEMATITE_FRAGMENT.get() || item == ModItems.CURSED_BOOK.get() || item == ModItems.RIP_FOSSIL.get() || item == ModItems.CHAIN_JEWELRY.get() || item == ModItems.FLORIDA_LEAVE.get()) {
            return 8;
        }
        if (item == ModItems.STONE_COIN.get() || item == ModItems.TOURMALINE_FRAGMENT.get() || item == ModItems.HEROBRINES_BOOK.get() || item == ModItems.THORAX_FOSSIL.get() || item == ModItems.RING_JEWELRY.get() || item == ModItems.BILLIETIAE_LEAVE.get()) {
            return 9;
        }
        Collectibles.LOGGER.error("Unknown Collectible!");
        return 0;
    }

    public static void dropCollectible(Level level, Player player, BlockPos pos, ItemStack collectible) {
        level.playSound((Entity)((Player)null), pos, SoundEvents.PLAYER_LEVELUP, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.15f + 0.0f);
        ExperienceOrb.award((ServerLevel)((ServerLevel)level), (Vec3)pos.getCenter(), (int)Config.getCollectiblesXp());
        player.awardStat(Stats.CUSTOM.get((Object)ModStats.COLLECTIBLES_FOUND.get()));
        if (Config.getLuckForCollectibles()) {
            player.addEffect(new MobEffectInstance(MobEffects.LUCK, 6000, 0));
        }
        if (Config.getCollectiblesDirectlyIntoInventory()) {
            player.addItem(collectible);
        } else {
            ItemEntity drop = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 1.5, (double)pos.getZ() + 0.5, collectible);
            level.addFreshEntity((Entity)drop);
        }
    }

    public static ItemStack parseItemEntry(String entry) {
        String[] parts = entry.split("\\*", 2);
        if (parts.length != 2) {
            throw new IllegalArgumentException("Invalid format: " + entry);
        }
        int amount = Integer.parseInt(parts[0]);
        String itemId = parts[1];
        ResourceLocation location = ResourceLocation.parse((String)itemId);
        Item item = (Item)BuiltInRegistries.ITEM.getValue(location);
        if (item == null) {
            throw new IllegalArgumentException("Unknown item: " + itemId);
        }
        return new ItemStack((ItemLike)item, amount);
    }
}

