/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.collectibles.utils;

import java.util.Arrays;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Items;
import net.neoforged.neoforge.common.ModConfigSpec;
import xxrexraptorxx.magmacore.config.ConfigHelper;
import xxrexraptorxx.magmacore.config.ConfigListHelper;

public class Config {
    private static final ModConfigSpec.Builder SERVER_BUILDER = new ModConfigSpec.Builder();
    public static ModConfigSpec SERVER_CONFIG;
    private static final ModConfigSpec.IntValue LOOT_BAG_XP;
    private static final ModConfigSpec.IntValue EPIC_LOOT_BAG_XP;
    private static ModConfigSpec.ConfigValue<List<? extends String>> LOOT_BAG_REWARDS;
    private static ModConfigSpec.ConfigValue<List<? extends String>> EPIC_LOOT_BAG_REWARDS;
    private static final ModConfigSpec.IntValue LOOT_BAG_ITEM_AMOUNT;
    private static final ModConfigSpec.IntValue EPIC_LOOT_BAG_ITEM_AMOUNT;
    private static final ModConfigSpec.IntValue COLLECTIBLES_XP;
    private static final ModConfigSpec.IntValue FRAGMENT_COLLECTIBLE_RARITY;
    private static final ModConfigSpec.IntValue FOSSIL_COLLECTIBLE_RARITY;
    private static final ModConfigSpec.IntValue LEAF_COLLECTIBLE_RARITY;
    private static final ModConfigSpec.IntValue COIN_COLLECTIBLE_RARITY;
    private static final ModConfigSpec.BooleanValue LUCK_FOR_COLLECTIBLES;
    private static final ModConfigSpec.BooleanValue COLLECTIBLES_DIRECTLY_INTO_INVENTORY;

    public static int getCollectiblesXp() {
        return (Integer)COLLECTIBLES_XP.get();
    }

    public static int getCoinCollectibleRarity() {
        return (Integer)COIN_COLLECTIBLE_RARITY.get();
    }

    public static int getFragmentCollectibleRarity() {
        return (Integer)FRAGMENT_COLLECTIBLE_RARITY.get();
    }

    public static int getFossilCollectibleRarity() {
        return (Integer)FOSSIL_COLLECTIBLE_RARITY.get();
    }

    public static int getLeafCollectibleRarity() {
        return (Integer)LEAF_COLLECTIBLE_RARITY.get();
    }

    public static int getLootBagXp() {
        return (Integer)LOOT_BAG_XP.get();
    }

    public static int getEpicLootBagXp() {
        return (Integer)EPIC_LOOT_BAG_XP.get();
    }

    public static int getLootBagItemAmount() {
        return (Integer)LOOT_BAG_ITEM_AMOUNT.get();
    }

    public static int getEpicLootBagItemAmount() {
        return (Integer)EPIC_LOOT_BAG_ITEM_AMOUNT.get();
    }

    public static boolean getLuckForCollectibles() {
        return (Boolean)LUCK_FOR_COLLECTIBLES.get();
    }

    public static boolean getCollectiblesDirectlyIntoInventory() {
        return (Boolean)COLLECTIBLES_DIRECTLY_INTO_INVENTORY.get();
    }

    public static List<String> getLootBagRewards() {
        return (List)LOOT_BAG_REWARDS.get();
    }

    public static List<String> getEpicLootBagRewards() {
        return (List)EPIC_LOOT_BAG_REWARDS.get();
    }

    static {
        ConfigHelper.setCategory((ModConfigSpec.Builder)SERVER_BUILDER, (String)"collectibles");
        COLLECTIBLES_XP = SERVER_BUILDER.comment("How much XP a player should get when finding a collectible").defineInRange("collectible_xp", 30, 0, 1000);
        LUCK_FOR_COLLECTIBLES = SERVER_BUILDER.comment("Should you get the Luck effect when you find a collectible?").define("luck_for_collectibles", true);
        COLLECTIBLES_DIRECTLY_INTO_INVENTORY = SERVER_BUILDER.comment("Should you get the collectible directly into your inventory when you find it instead of it dropping?").define("collectibles_directly_into_inventory", false);
        COIN_COLLECTIBLE_RARITY = SERVER_BUILDER.comment("How rarely coin collectibles drop. Higher = rarer [1:X]").defineInRange("coin_collectibles_rarity", 1000, 1, 100000);
        FRAGMENT_COLLECTIBLE_RARITY = SERVER_BUILDER.comment("How rarely fragment collectibles drop. Higher = rarer [1:X]").defineInRange("fragment_collectibles_rarity", 1000, 1, 100000);
        FOSSIL_COLLECTIBLE_RARITY = SERVER_BUILDER.comment("How rarely fossil collectibles drop. Higher = rarer [1:X]").defineInRange("fossil_collectibles_rarity", 1000, 1, 100000);
        LEAF_COLLECTIBLE_RARITY = SERVER_BUILDER.comment("How rarely leaf collectibles drop. Higher = rarer [1:X]").defineInRange("leaf_collectibles_rarity", 1000, 1, 100000);
        SERVER_BUILDER.pop();
        ConfigHelper.setCategory((ModConfigSpec.Builder)SERVER_BUILDER, (String)"loot_bags");
        EPIC_LOOT_BAG_XP = SERVER_BUILDER.comment("How much XP a player gets from an epic loot bag").defineInRange("epic_loot_bag_xp", 100, 0, 1000);
        EPIC_LOOT_BAG_ITEM_AMOUNT = SERVER_BUILDER.comment("How many item entries the epic loot bag gives").defineInRange("epic_loot_bag_item_amount", 3, 1, 10);
        EPIC_LOOT_BAG_REWARDS = SERVER_BUILDER.comment("Epic loot bag rewards [amount*modid:item]").defineListAllowEmpty("epic_loot_bag_rewards", Arrays.asList("1*" + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)Items.NETHERITE_INGOT)), "1*" + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)Items.NETHER_STAR)), "1*" + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)Items.END_CRYSTAL)), "1*" + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)Items.ELYTRA)), "1*" + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)Items.TOTEM_OF_UNDYING)), "1*" + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)Items.ENCHANTED_GOLDEN_APPLE)), "1*" + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)Items.HEAVY_CORE)), "1*" + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)Items.HEART_OF_THE_SEA)), "1*" + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)Items.OMINOUS_TRIAL_KEY)), "3*" + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)Items.NETHERITE_SCRAP)), "4*" + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)Items.ECHO_SHARD)), "5*" + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)Items.DRAGON_BREATH)), "10*" + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)Items.DIAMOND))), () -> "amount*modid:item", obj -> {
            String string;
            return obj instanceof String && ConfigListHelper.isValidItemWithCount((String)(string = (String)obj));
        });
        LOOT_BAG_XP = SERVER_BUILDER.comment("How much XP a player gets from a loot bag").defineInRange("loot_bag_xp", 50, 0, 1000);
        LOOT_BAG_ITEM_AMOUNT = SERVER_BUILDER.comment("How many item entries the loot bag gives").defineInRange("loot_bag_item_amount", 1, 1, 10);
        LOOT_BAG_REWARDS = SERVER_BUILDER.comment("Loot bag rewards [amount*modid:item]").defineListAllowEmpty("loot_bag_rewards", Arrays.asList("3*" + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)Items.EMERALD)), "3*" + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)Items.DIAMOND)), "1*" + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)Items.GOLDEN_APPLE)), "1*" + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)Items.ENDER_EYE)), "1*" + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)Items.ECHO_SHARD)), "1*" + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)Items.BREEZE_ROD)), "3*" + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)Items.WIND_CHARGE)), "3*" + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)Items.FIRE_CHARGE)), "1*" + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)Items.BLAZE_ROD)), "3*" + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)Items.EXPERIENCE_BOTTLE)), "1*" + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)Items.TRIAL_KEY))), () -> "amount*modid:item", obj -> {
            String string;
            return obj instanceof String && ConfigListHelper.isValidItemWithCount((String)(string = (String)obj));
        });
        SERVER_BUILDER.pop();
        SERVER_CONFIG = SERVER_BUILDER.build();
    }
}

