/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.collectibles.world;

import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.village.WandererTradesEvent;
import xxrexraptorxx.collectibles.registry.ModItems;
import xxrexraptorxx.collectibles.registry.ModTags;
import xxrexraptorxx.collectibles.utils.CollectibleHelper;
import xxrexraptorxx.collectibles.utils.Config;

@EventBusSubscriber(modid="collectibles")
public class Events {
    @SubscribeEvent
    public static void onBlockDestroyed(BlockEvent.BreakEvent event) {
        Random random = new Random();
        Level level = event.getPlayer().level();
        BlockState block = event.getState();
        BlockPos pos = event.getPos();
        Player player = event.getPlayer();
        if (!level.isClientSide()) {
            if (block.is(ModTags.DROPS_FRAGMENTS)) {
                if (random.nextInt(Config.getFragmentCollectibleRarity()) == 1) {
                    CollectibleHelper.dropCollectible(level, player, pos, CollectibleHelper.getRandomFragment());
                }
            } else if (block.is(ModTags.DROPS_COINS)) {
                if (random.nextInt(Config.getCoinCollectibleRarity()) == 1) {
                    CollectibleHelper.dropCollectible(level, player, pos, CollectibleHelper.getRandomCoin());
                }
            } else if (block.is(ModTags.DROPS_FOSSILS)) {
                if (random.nextInt(Config.getFossilCollectibleRarity()) == 1) {
                    CollectibleHelper.dropCollectible(level, player, pos, CollectibleHelper.getRandomFossil());
                }
            } else if (block.is(ModTags.DROPS_LEAVES) && random.nextInt(Config.getLeafCollectibleRarity()) == 1) {
                CollectibleHelper.dropCollectible(level, player, pos, CollectibleHelper.getRandomLeave());
            }
        }
    }

    @SubscribeEvent
    public static void addCustomWanderingTrades(WandererTradesEvent event) {
        List trades = event.getRareTrades();
        ItemStack reward = new ItemStack((ItemLike)Items.EMERALD, 30);
        trades.add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)ModItems.GOLD_COIN.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)ModItems.SILVER_COIN.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)ModItems.PLATINUM_COIN.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)ModItems.NETHERITE_COIN.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)ModItems.COPPER_COIN.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)ModItems.BRONZE_COIN.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)ModItems.BRASS_COIN.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)ModItems.IRON_COIN.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)ModItems.STONE_COIN.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)ModItems.DIAMOND_FRAGMENT.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)ModItems.EMERALD_FRAGMENT.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)ModItems.AMETHYST_FRAGMENT.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)ModItems.RUBY_FRAGMENT.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)ModItems.SAPPHIRE_FRAGMENT.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)ModItems.TOPAZ_FRAGMENT.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)ModItems.CRYSTAL_FRAGMENT.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)ModItems.HEMATITE_FRAGMENT.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)ModItems.TOURMALINE_FRAGMENT.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)ModItems.OLD_BOOK.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)ModItems.NECRONOMICON_BOOK.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)ModItems.KNOWLEDGE_BOOK.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)ModItems.NOTCHS_BOOK.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)ModItems.DARKHOLD_BOOK.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)ModItems.MONSTER_BOOK.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)ModItems.GRIMOIRE_BOOK.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)ModItems.CURSED_BOOK.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)ModItems.HEROBRINES_BOOK.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)ModItems.CLAW_FOSSIL.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)ModItems.LEG_FOSSIL.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)ModItems.AMMONITE_FOSSIL.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)ModItems.CRINOID_FOSSIL.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)ModItems.TRILOBITE_FOSSIL.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)ModItems.SKULL_FOSSIL.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)ModItems.SPINE_FOSSIL.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)ModItems.RIP_FOSSIL.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)ModItems.THORAX_FOSSIL.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)ModItems.AMULET_JEWELRY.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)ModItems.HAIRPIN_JEWELRY.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)ModItems.BRACELET_JEWELRY.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)ModItems.BROOCH_JEWELRY.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)ModItems.EARRING_JEWELRY.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)ModItems.DIADEM_JEWELRY.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)ModItems.CROWN_JEWELRY.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)ModItems.CHAIN_JEWELRY.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)ModItems.RING_JEWELRY.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)ModItems.DELICIOSA_LEAVE.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)ModItems.AUREA_LEAVE.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)ModItems.OBLIQUA_LEAVE.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)ModItems.SUBPINNATA_LEAVE.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)ModItems.FRYDEK_LEAVE.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)ModItems.JACKLYN_LEAVE.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)ModItems.SABRINA_LEAVE.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)ModItems.FLORIDA_LEAVE.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)ModItems.BILLIETIAE_LEAVE.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 30), new ItemStack((ItemLike)ModItems.LOOT_BAG.get()), 1, 10, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD_BLOCK, 10), new ItemStack((ItemLike)ModItems.EPIC_LOOT_BAG.get()), 1, 15, 0.05f));
    }
}

