/*
 * Decompiled with CFR 0.152.
 */
package net.nikdo53.tinymultiblocklib.block;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.nikdo53.tinymultiblocklib.Constants;
import net.nikdo53.tinymultiblocklib.block.AbstractMultiBlock;
import net.nikdo53.tinymultiblocklib.block.IMBStateSyncer;
import net.nikdo53.tinymultiblocklib.blockentities.IMultiBlockEntity;

public interface IMultiBlock
extends IMBStateSyncer {
    public List<BlockPos> makeFullBlockShape(@Nullable Direction var1, BlockPos var2, BlockState var3);

    public static List<BlockPos> posStreamToList(Stream<BlockPos> posStream) {
        return new ArrayList<BlockPos>(posStream.map(BlockPos::m_7949_).toList());
    }

    @Nullable
    default public DirectionProperty getDirectionProperty() {
        return null;
    }

    @Nullable
    default public Direction getDirection(BlockState state) {
        if (this.getDirectionProperty() != null) {
            return (Direction)state.m_61143_((Property)this.getDirectionProperty());
        }
        return null;
    }

    default public List<BlockPos> getFullBlockShapeNoCache(BlockPos center, BlockState state) {
        List<BlockPos> list = this.getDirectionProperty() == null ? this.makeFullBlockShape(null, center, state) : this.makeFullBlockShape((Direction)state.m_61143_((Property)this.getDirectionProperty()), center, state);
        HashSet<BlockPos> set = new HashSet<BlockPos>(list);
        if (set.size() < list.size()) {
            Constants.LOGGER.error("Multiblock {} at {} has overlapping blocks in it's shape, this is likely caused by the BlockPos being mutable. Either map them to BlockPos::immutable or use IMultiBlock.posStreamToList()", (Object)state.toString(), (Object)center);
        }
        return list;
    }

    default public List<BlockPos> getFullBlockShape(BlockPos pos, BlockState state, BlockGetter level) {
        BlockPos center = IMultiBlock.getCenter(level, pos);
        BlockEntity blockEntity = level.m_7702_(center);
        if (!(blockEntity instanceof IMultiBlockEntity)) {
            return this.getFullBlockShapeNoCache(center, state);
        }
        IMultiBlockEntity blockEntity2 = (IMultiBlockEntity)blockEntity;
        if (blockEntity2.getFullBlockShapeCache().isEmpty()) {
            List<BlockPos> blockPosList = this.getFullBlockShapeNoCache(center, state);
            blockPosList.forEach(BlockPos::m_7949_);
            blockEntity2.setFullBlockShapeCache(blockPosList);
            return blockPosList;
        }
        return blockEntity2.getFullBlockShapeCache();
    }

    public static List<BlockPos> getFullShape(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof IMultiBlock) {
            IMultiBlock multiBlock = (IMultiBlock)block;
            return multiBlock.getFullBlockShape(pos, state, (BlockGetter)level);
        }
        return List.of(pos);
    }

    public static void invalidateCaches(BlockGetter level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(IMultiBlock.getCenter(level, pos));
        if (blockEntity instanceof IMultiBlockEntity) {
            IMultiBlockEntity blockEntity2 = (IMultiBlockEntity)blockEntity;
            blockEntity2.invalidateCaches();
        }
    }

    default public BlockState getStateForEachBlock(BlockState state, BlockPos pos, BlockPos centerOffset, Level level, @Nullable Direction direction) {
        return state;
    }

    default public void onPlaceHelper(BlockState state, Level level, BlockPos pos, BlockState oldState) {
        boolean isPlaced = IMultiBlockEntity.isPlaced((LevelReader)level, pos);
        if (isPlaced) {
            this.syncBlockStates(level, pos, state);
        }
        if (IMultiBlock.isCenter(state) && !isPlaced) {
            this.place(level, pos, state);
        }
    }

    default public void place(Level level, BlockPos centerPos, BlockState stateOriginal) {
        this.prepareForPlace(level, centerPos, stateOriginal).forEach(pair -> {
            IMultiBlockEntity entity;
            BlockEntity patt5667$temp;
            int flags = 66;
            BlockState stateNew = (BlockState)pair.getSecond();
            BlockPos posNew = (BlockPos)pair.getFirst();
            if (!level.m_8055_(posNew).equals(stateNew)) {
                level.m_7731_(posNew, stateNew, flags);
            }
            if ((patt5667$temp = level.m_7702_(posNew)) instanceof IMultiBlockEntity && !(entity = (IMultiBlockEntity)patt5667$temp).getCenter().equals((Object)centerPos)) {
                entity.setCenter(centerPos);
                entity.getBlockEntity().m_6596_();
            }
        });
    }

    default public List<Pair<BlockPos, BlockState>> prepareForPlace(Level level, BlockPos centerPos, BlockState stateOriginal) {
        ArrayList<Pair<BlockPos, BlockState>> list = new ArrayList<Pair<BlockPos, BlockState>>();
        this.getFullBlockShape(centerPos, stateOriginal, (BlockGetter)level).forEach(posNew -> {
            posNew = posNew.m_7949_();
            BlockState stateNew = (BlockState)stateOriginal.m_61124_((Property)AbstractMultiBlock.CENTER, (Comparable)Boolean.valueOf(centerPos.equals(posNew)));
            stateNew = this.getStateForEachBlock(stateNew, (BlockPos)posNew, posNew.m_121996_((Vec3i)centerPos), level, this.getDirection(stateOriginal));
            list.add(new Pair(posNew, (Object)stateNew));
        });
        return list;
    }

    default public BlockState getStateForPlacementHelper(BlockPlaceContext context) {
        return this.getStateForPlacementHelper(context, context.m_8125_());
    }

    default public BlockState getStateForPlacementHelper(BlockPlaceContext context, Direction direction) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState state = (BlockState)this.self().m_49966_().m_61124_((Property)AbstractMultiBlock.CENTER, (Comparable)Boolean.valueOf(true));
        if (this.getDirectionProperty() != null) {
            state = (BlockState)state.m_61124_((Property)this.getDirectionProperty(), (Comparable)direction);
        }
        return this.canPlace((LevelReader)level, pos, state, (Entity)context.m_43723_(), false) ? state : null;
    }

    default public boolean canPlace(LevelReader level, BlockPos center, BlockState state, @Nullable Entity player, boolean ignoreEntities) {
        return this.getFullBlockShape(center, state, (BlockGetter)level).stream().allMatch(blockPos -> this.canReplaceBlock(level, (BlockPos)blockPos, level.m_8055_(blockPos)) && this.extraSurviveRequirements(level, (BlockPos)blockPos, state, blockPos.m_121996_((Vec3i)center)) && (this.entityUnobstructed((CollisionGetter)level, (BlockPos)blockPos, state, player) || ignoreEntities));
    }

    default public boolean canReplaceBlock(LevelReader level, BlockPos blockPos, BlockState state) {
        return state.m_247087_();
    }

    default public boolean entityUnobstructed(CollisionGetter level, BlockPos pos, BlockState state, @Nullable Entity player) {
        CollisionContext context = player == null ? CollisionContext.m_82749_() : CollisionContext.m_82750_((Entity)player);
        return this.getFullBlockShape(pos, state, (BlockGetter)level).stream().allMatch(blockPos -> level.m_45752_(state, blockPos, context));
    }

    default public void destroy(BlockPos center, Level level, BlockState state, boolean dropBlock) {
        if (level.m_5776_()) {
            return;
        }
        List<BlockPos> blocks = this.getFullBlockShape(center, state, (BlockGetter)level);
        level.m_46961_(center, dropBlock);
        blocks.forEach(pos -> {
            Block block;
            BlockState blockState = level.m_8055_(pos);
            if (blockState.m_60713_(block = state.m_60734_())) {
                level.m_46961_(pos, dropBlock);
            }
        });
    }

    default public boolean allBlocksPresent(LevelReader level, BlockPos pos, BlockState state) {
        IMultiBlockEntity entity;
        BlockEntity blockEntity;
        if (level.m_5776_()) {
            return true;
        }
        BlockPos center = IMultiBlock.getCenter((BlockGetter)level, pos);
        boolean ret = this.getFullBlockShape(center, state, (BlockGetter)level).stream().allMatch(blockPos -> level.m_8055_(blockPos).m_60713_(this.self()));
        boolean isMultiblock = IMultiBlock.isMultiblock((BlockGetter)level, pos);
        if (ret && (blockEntity = level.m_7702_(pos)) instanceof IMultiBlockEntity && !(entity = (IMultiBlockEntity)blockEntity).isPlaced() && isMultiblock) {
            this.getFullBlockShape(center, state, (BlockGetter)level).forEach(blockPos -> IMultiBlockEntity.setPlaced(level, blockPos, true));
        }
        return ret;
    }

    default public BlockState updateShapeHelper(BlockState state, LevelAccessor level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof IMultiBlockEntity) {
            IMultiBlockEntity entity = (IMultiBlockEntity)blockEntity;
            BlockPos centerPos = IMultiBlock.getCenter((BlockGetter)level, pos);
            boolean canSurvive = state.m_60710_((LevelReader)level, centerPos);
            if (!canSurvive) {
                this.destroy(entity.getCenter(), (Level)level, state, true);
                return Blocks.f_50016_.m_49966_();
            }
        } else {
            return Blocks.f_50016_.m_49966_();
        }
        return state;
    }

    default public boolean canSurviveHelper(BlockState state, LevelReader level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof IMultiBlockEntity) {
            IMultiBlockEntity entity = (IMultiBlockEntity)blockEntity;
            boolean extraSurvive = this.getFullBlockShape(pos, state, (BlockGetter)level).stream().allMatch(blockPos -> this.extraSurviveRequirements(level, (BlockPos)blockPos, state, entity.getOffset()));
            return (this.allBlocksPresent(level, pos, state) || !entity.isPlaced()) && extraSurvive;
        }
        return this.canPlace(level, pos, state, null, false);
    }

    @Deprecated
    default public boolean extraSurviveRequirements(LevelReader level, BlockPos pos, BlockState state) {
        return true;
    }

    default public boolean extraSurviveRequirements(LevelReader level, BlockPos pos, BlockState state, BlockPos centerOffset) {
        return this.extraSurviveRequirements(level, pos, state);
    }

    default public void preventCreativeDrops(Player player, Level level, BlockPos pos) {
        if (player.m_7500_() && level.m_7702_(pos) instanceof IMultiBlockEntity) {
            BlockPos center = IMultiBlock.getCenter((BlockGetter)level, pos);
            this.destroy(center, level, level.m_8055_(pos), false);
        }
    }

    public static BlockPos getCenter(BlockGetter level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof IMultiBlockEntity) {
            IMultiBlockEntity entity = (IMultiBlockEntity)blockEntity;
            return entity.getCenter();
        }
        return pos;
    }

    public static BlockPos getOffset(BlockGetter level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof IMultiBlockEntity) {
            IMultiBlockEntity entity = (IMultiBlockEntity)blockEntity;
            return entity.getOffset();
        }
        return new BlockPos(0, 0, 0);
    }

    public static boolean isCenter(BlockState state) {
        return (Boolean)state.m_61143_((Property)AbstractMultiBlock.CENTER);
    }

    public static boolean isMultiblock(BlockState state) {
        return state.m_60734_() instanceof IMultiBlock;
    }

    public static boolean isMultiblock(BlockGetter level, BlockPos pos) {
        return IMultiBlock.isMultiblock(level.m_8055_(pos));
    }

    default public VoxelShape voxelShapeHelper(BlockState state, BlockGetter level, BlockPos pos, VoxelShape shape) {
        return this.voxelShapeHelper(state, level, pos, shape, 0.0f, 0.0f, 0.0f);
    }

    default public VoxelShape voxelShapeHelper(BlockState state, BlockGetter level, BlockPos pos, VoxelShape shape, float xOffset, float yOffset, float zOffset) {
        return this.voxelShapeHelper(state, level, pos, shape, xOffset, yOffset, zOffset, false);
    }

    default public VoxelShape voxelShapeHelper(BlockState state, BlockGetter level, BlockPos pos, VoxelShape shape, float xOffset, float yOffset, float zOffset, boolean hasDirectionOffsets) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof IMultiBlockEntity) {
            IMultiBlockEntity entity = (IMultiBlockEntity)blockEntity;
            float x = (float)(-entity.getOffset().m_123341_()) + xOffset;
            float y = (float)(-entity.getOffset().m_123342_()) + yOffset;
            float z = (float)(-entity.getOffset().m_123343_()) + zOffset;
            if (this.getDirectionProperty() != null && hasDirectionOffsets) {
                switch ((Direction)state.m_61143_((Property)this.getDirectionProperty())) {
                    case EAST: {
                        x += 1.0f;
                        break;
                    }
                    case NORTH: {
                        x += 1.0f;
                        z -= 1.0f;
                        break;
                    }
                    case WEST: {
                        z -= 1.0f;
                    }
                }
            }
            return shape.m_83216_((double)x, (double)y, (double)z);
        }
        return shape;
    }

    public static boolean isSameMultiblock(Level level, BlockState state1, BlockState state2, BlockPos center, BlockPos posNew) {
        IMultiBlockEntity entity;
        BlockEntity blockEntity;
        return state1.m_60734_().equals(state2.m_60734_()) && (blockEntity = level.m_7702_(posNew)) instanceof IMultiBlockEntity && (entity = (IMultiBlockEntity)blockEntity).getCenter().equals((Object)center);
    }

    private Block self() {
        IMultiBlock iMultiBlock = this;
        if (iMultiBlock instanceof Block) {
            Block block = (Block)iMultiBlock;
            return block;
        }
        throw new RuntimeException(this.getClass().getSimpleName() + " is not implemented on a Block");
    }
}

