/*
 * Decompiled with CFR 0.152.
 */
package net.nikdo53.tinymultiblocklib.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.nikdo53.tinymultiblocklib.blockentities.IMultiBlockEntity;
import net.nikdo53.tinymultiblocklib.components.PreviewMode;

public interface IMultiblockRenderHelper {
    default public Function<ResourceLocation, RenderType> getRenderTypeFunction(PreviewMode previewMode) {
        return this.getRenderTypeFunction(previewMode, RenderType::m_110470_);
    }

    default public Function<ResourceLocation, RenderType> getRenderTypeFunction(PreviewMode previewMode, Function<ResourceLocation, RenderType> defaultRenderType) {
        return previewMode.equals((Object)PreviewMode.PLACED) ? RenderType::m_110452_ : defaultRenderType;
    }

    default public RenderType getRenderType(PreviewMode previewMode, ResourceLocation texture) {
        return this.getRenderType(previewMode, texture, RenderType.m_110470_((ResourceLocation)texture));
    }

    default public RenderType getRenderType(PreviewMode previewMode, ResourceLocation texture, RenderType defaultRenderType) {
        return previewMode.equals((Object)PreviewMode.PLACED) ? RenderType.m_110452_((ResourceLocation)texture) : defaultRenderType;
    }

    default public VertexConsumer getConsumer(MultiBufferSource buffer, IMultiBlockEntity blockEntity, Material materialBase, Material materialSecondary, Block blockSecondary) {
        PreviewMode previewMode = blockEntity.getPreviewMode();
        RenderType renderTypeBase = this.getRenderType(previewMode, materialBase.m_119193_());
        RenderType renderTypeCorrupted = this.getRenderType(previewMode, materialSecondary.m_119193_());
        VertexConsumer baseConsumer = materialBase.m_119204_().m_118381_(buffer.m_6299_(renderTypeBase));
        VertexConsumer corruptedConsumer = materialSecondary.m_119204_().m_118381_(buffer.m_6299_(renderTypeCorrupted));
        return blockEntity.getBlockEntity().m_58900_().m_60713_(blockSecondary) ? corruptedConsumer : baseConsumer;
    }

    default public Level level() {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            throw new IllegalStateException("BlockEntityRenderer Level is null");
        }
        return level;
    }

    default public void render(ModelPart modelPart, PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, PreviewMode previewMode) {
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        float alpha = 1.0f;
        this.render(modelPart, poseStack, vertexConsumer, packedLight, packedOverlay, r, g, b, alpha, previewMode);
    }

    default public void render(ModelPart modelPart, PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float r, float g, float b, float alpha, PreviewMode previewMode) {
        float[] rgba = previewMode.applyColorsFloat(r, g, b, alpha);
        modelPart.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, rgba[0], rgba[1], rgba[2], rgba[3]);
    }
}

