/*
 * Decompiled with CFR 0.152.
 */
package net.nikdo53.tinymultiblocklib.block;

import java.util.function.BiFunction;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.nikdo53.tinymultiblocklib.block.AbstractMultiBlock;
import net.nikdo53.tinymultiblocklib.blockentities.IMultiBlockEntity;

public interface IMultiBlock {
    public Stream<BlockPos> fullBlockShape(@Nullable Direction var1, BlockPos var2);

    @Nullable
    default public DirectionProperty getDirectionProperty() {
        return null;
    }

    @Nullable
    default public Direction getDirection(BlockState state) {
        if (this.getDirectionProperty() != null) {
            return (Direction)state.getValue((Property)this.getDirectionProperty());
        }
        return null;
    }

    default public Block getBlock() {
        IMultiBlock iMultiBlock = this;
        if (iMultiBlock instanceof Block) {
            Block block = (Block)iMultiBlock;
            return block;
        }
        throw new RuntimeException(this.getClass().getSimpleName() + " is not implemented on a Block");
    }

    default public Stream<BlockPos> fullBlockShape(BlockPos center, @Nullable BlockState state) {
        if (this.getDirectionProperty() == null || state == null) {
            return this.fullBlockShape(null, center);
        }
        return this.fullBlockShape((Direction)state.getValue((Property)this.getDirectionProperty()), center);
    }

    public static Stream<BlockPos> getFullShape(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof IMultiBlockEntity) {
            IMultiBlockEntity multiBlockEntity = (IMultiBlockEntity)blockEntity;
            blockEntity = level.getBlockState(pos).getBlock();
            if (blockEntity instanceof IMultiBlock) {
                IMultiBlock multiBlock = (IMultiBlock)blockEntity;
                return multiBlock.fullBlockShape(multiBlockEntity.getCenter(), level.getBlockState(pos));
            }
        }
        return Stream.of(pos);
    }

    @Nullable
    default public BiFunction<BlockState, BlockPos, BlockState> getStateFromOffset() {
        return null;
    }

    default public void place(Level level, BlockPos posOriginal, BlockState stateOriginal) {
        this.fullBlockShape(posOriginal, stateOriginal).forEach(posNew -> {
            int flags = level.isClientSide ? 0 : 3;
            BlockState stateNew = (BlockState)stateOriginal.setValue((Property)AbstractMultiBlock.CENTER, (Comparable)Boolean.valueOf(posOriginal.equals(posNew)));
            if (this.getStateFromOffset() != null) {
                stateNew = this.getStateFromOffset().apply(stateNew, posNew.subtract((Vec3i)posOriginal));
            }
            level.setBlock(posNew, stateNew, flags);
            BlockEntity patt0$temp = level.getBlockEntity(posNew);
            if (patt0$temp instanceof IMultiBlockEntity) {
                IMultiBlockEntity entity = (IMultiBlockEntity)patt0$temp;
                entity.setCenter(posOriginal);
                entity.getBlockEntity().setChanged();
            }
        });
    }

    default public BlockState getStateForPlacementHelper(BlockPlaceContext context) {
        return this.getStateForPlacementHelper(context, context.getHorizontalDirection());
    }

    default public BlockState getStateForPlacementHelper(BlockPlaceContext context, Direction direction) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = (BlockState)this.getBlock().defaultBlockState().setValue((Property)AbstractMultiBlock.CENTER, (Comparable)Boolean.valueOf(true));
        if (this.getDirectionProperty() != null) {
            state = (BlockState)state.setValue((Property)this.getDirectionProperty(), (Comparable)direction);
        }
        return this.canPlace((LevelReader)level, pos, state) ? state : null;
    }

    default public boolean canPlace(LevelReader level, BlockPos center, BlockState state) {
        return this.fullBlockShape(center, state).allMatch(blockPos -> level.getBlockState(blockPos).canBeReplaced() && this.extraSurviveRequirements(level, (BlockPos)blockPos, state));
    }

    default public void destroy(BlockPos center, Level level, BlockState state) {
        if (level.isClientSide()) {
            return;
        }
        this.fullBlockShape(center, state).forEach(pos -> {
            Block block;
            BlockState blockState = level.getBlockState(pos);
            if (blockState.is(block = state.getBlock())) {
                level.destroyBlock(pos, true);
            }
        });
    }

    default public boolean allBlocksPresent(LevelReader level, BlockPos pos, BlockState state) {
        IMultiBlockEntity entity;
        BlockEntity blockEntity;
        if (level.isClientSide()) {
            return true;
        }
        BlockPos center = IMultiBlock.getCenter((BlockGetter)level, pos);
        boolean ret = this.fullBlockShape(center, state).allMatch(blockPos -> level.getBlockState(blockPos).is(this.getBlock()));
        if (ret && (blockEntity = level.getBlockEntity(pos)) instanceof IMultiBlockEntity && !(entity = (IMultiBlockEntity)blockEntity).isPlaced()) {
            this.fullBlockShape(center, state).forEach(blockPos -> IMultiBlockEntity.setPlaced(level, blockPos));
        }
        return ret;
    }

    default public BlockState updateShapeHelper(BlockState state, LevelAccessor level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof IMultiBlockEntity) {
            IMultiBlockEntity entity = (IMultiBlockEntity)blockEntity;
            boolean canSurvive = state.canSurvive((LevelReader)level, pos);
            if (!canSurvive) {
                this.destroy(entity.getCenter(), (Level)level, state);
                return Blocks.AIR.defaultBlockState();
            }
        } else {
            level.destroyBlock(pos, true);
            return Blocks.AIR.defaultBlockState();
        }
        return state;
    }

    default public boolean canSurviveHelper(BlockState state, LevelReader level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof IMultiBlockEntity) {
            IMultiBlockEntity entity = (IMultiBlockEntity)blockEntity;
            boolean extraSurvive = this.fullBlockShape(entity.getCenter(), state).allMatch(blockPos -> this.extraSurviveRequirements(level, (BlockPos)blockPos, state));
            return (this.allBlocksPresent(level, pos, state) || !entity.isPlaced()) && extraSurvive;
        }
        return this.canPlace(level, pos, state);
    }

    default public boolean extraSurviveRequirements(LevelReader level, BlockPos pos, BlockState state) {
        return true;
    }

    default public void preventCreativeDrops(Player player, Level level, BlockPos pos) {
        BlockEntity blockEntity;
        if (player.isCreative() && (blockEntity = level.getBlockEntity(pos)) instanceof IMultiBlockEntity) {
            IMultiBlockEntity entity = (IMultiBlockEntity)blockEntity;
            level.destroyBlock(entity.getCenter(), false);
        }
    }

    default public void fixInStructures(BlockState state, ServerLevelAccessor level, BlockPos pos) {
        if (IMultiBlock.isCenter(state)) {
            level.scheduleTick(pos, state.getBlock(), 3);
        }
    }

    default public void fixTick(BlockState state, Level level, BlockPos pos) {
        if (IMultiBlock.isCenter(state)) {
            this.fullBlockShape(pos, state).forEach(posNew -> {
                BlockEntity patt0$temp = level.getBlockEntity(posNew);
                if (patt0$temp instanceof IMultiBlockEntity) {
                    IMultiBlockEntity entity = (IMultiBlockEntity)patt0$temp;
                    entity.setCenter(pos);
                    entity.getBlockEntity().setChanged();
                    level.sendBlockUpdated(posNew, state, state, 2);
                }
            });
        }
    }

    default public boolean isBroken(LevelReader level, BlockPos pos, BlockState state) {
        if (!IMultiBlock.isCenter(state)) {
            return false;
        }
        return this.fullBlockShape(pos, state).anyMatch(blockPos -> {
            BlockEntity patt0$temp = level.getBlockEntity(blockPos);
            if (patt0$temp instanceof IMultiBlockEntity) {
                IMultiBlockEntity entity = (IMultiBlockEntity)patt0$temp;
                return !entity.getCenter().equals((Object)pos) || IMultiBlock.isCenter(level.getBlockState(blockPos));
            }
            return true;
        });
    }

    public static BlockPos getCenter(BlockGetter level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof IMultiBlockEntity) {
            IMultiBlockEntity entity = (IMultiBlockEntity)blockEntity;
            return entity.getCenter();
        }
        return pos;
    }

    public static boolean isCenter(LevelReader level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof IMultiBlockEntity) {
            IMultiBlockEntity entity = (IMultiBlockEntity)blockEntity;
            return entity.getCenter().equals((Object)pos);
        }
        return false;
    }

    public static boolean isCenter(BlockState state) {
        return (Boolean)state.getValue((Property)AbstractMultiBlock.CENTER);
    }

    public static boolean isMultiblock(BlockState state) {
        return state.getBlock() instanceof IMultiBlock;
    }

    public static boolean isMultiblock(BlockGetter level, BlockPos pos) {
        return IMultiBlock.isMultiblock(level.getBlockState(pos));
    }

    public static int getXOffset(BlockGetter level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof IMultiBlockEntity) {
            IMultiBlockEntity entity = (IMultiBlockEntity)blockEntity;
            return pos.getX() - entity.getCenter().getX();
        }
        return 0;
    }

    public static int getYOffset(BlockGetter level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof IMultiBlockEntity) {
            IMultiBlockEntity entity = (IMultiBlockEntity)blockEntity;
            return pos.getY() - entity.getCenter().getY();
        }
        return 0;
    }

    public static int getZOffset(BlockGetter level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof IMultiBlockEntity) {
            IMultiBlockEntity entity = (IMultiBlockEntity)blockEntity;
            return pos.getZ() - entity.getCenter().getZ();
        }
        return 0;
    }

    default public VoxelShape voxelShapeHelper(BlockState state, BlockGetter level, BlockPos pos, VoxelShape shape) {
        return this.voxelShapeHelper(state, level, pos, shape, 0.0f, 0.0f, 0.0f);
    }

    default public VoxelShape voxelShapeHelper(BlockState state, BlockGetter level, BlockPos pos, VoxelShape shape, float xOffset, float yOffset, float zOffset) {
        return this.voxelShapeHelper(state, level, pos, shape, xOffset, yOffset, zOffset, false);
    }

    default public VoxelShape voxelShapeHelper(BlockState state, BlockGetter level, BlockPos pos, VoxelShape shape, float xOffset, float yOffset, float zOffset, boolean hasDirectionOffsets) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof IMultiBlockEntity) {
            IMultiBlockEntity entity = (IMultiBlockEntity)blockEntity;
            float x = (float)(entity.getCenter().getX() - pos.getX()) + xOffset;
            float y = (float)(entity.getCenter().getY() - pos.getY()) + yOffset;
            float z = (float)(entity.getCenter().getZ() - pos.getZ()) + zOffset;
            if (this.getDirectionProperty() != null && hasDirectionOffsets) {
                switch ((Direction)state.getValue((Property)this.getDirectionProperty())) {
                    case EAST: {
                        x += 1.0f;
                        break;
                    }
                    case NORTH: {
                        x += 1.0f;
                        z -= 1.0f;
                        break;
                    }
                    case WEST: {
                        z -= 1.0f;
                    }
                }
            }
            return shape.move((double)x, (double)y, (double)z);
        }
        return shape;
    }

    default public void growHelper(Level level, BlockPos blockPos, IntegerProperty ageProperty) {
        Block block = this.getBlock();
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof IMultiBlockEntity) {
            IMultiBlockEntity entity = (IMultiBlockEntity)blockEntity;
            this.fullBlockShape(entity.getCenter(), level.getBlockState(blockPos)).forEach(pos -> {
                if (level.getBlockState(pos).is(block)) {
                    BlockState blockState = level.getBlockState(pos);
                    int age = (Integer)blockState.getValue((Property)ageProperty);
                    if ((Integer)blockState.getValue((Property)ageProperty) >= this.getMaxAge(ageProperty)) {
                        return;
                    }
                    level.setBlock(pos, (BlockState)blockState.setValue((Property)ageProperty, (Comparable)Integer.valueOf(age + 1)), 2);
                } else {
                    level.destroyBlock(pos, false);
                }
            });
        } else {
            level.destroyBlock(blockPos, true);
        }
    }

    default public int getMaxAge(IntegerProperty ageProperty) {
        return (Integer)ageProperty.getPossibleValues().stream().toList().get(ageProperty.getPossibleValues().size() - 1);
    }
}

