package net.nikdo53.tinymultiblocklib.blockentities;

import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_4538;
import net.nikdo53.tinymultiblocklib.components.PreviewMode;

import java.util.List;

public interface IMultiBlockEntity {
    class_2338 getOffset();
    void setOffset(class_2338 offset);

    /**
     * True once the whole placing logic runs (to prevent updateShape from breaking it early)
     * */
    boolean isPlaced();
    void setPlaced(boolean placed);

    List<class_2338> getFullBlockShapeCache();
    void setFullBlockShapeCache(List<class_2338> shapeCache);

    void invalidateCaches();

    PreviewMode getPreviewMode();
    void setPreviewMode(PreviewMode mode);

    static void setPlaced(class_4538 level, class_2338 blockPos, boolean placed) {
        if(level.method_8321(blockPos) instanceof IMultiBlockEntity entity) entity.setPlaced(placed);
    }

    static boolean isPlaced(class_4538 level, class_2338 blockPos) {
        if(level.method_8321(blockPos) instanceof IMultiBlockEntity entity) return entity.isPlaced();
        return false;
    }

    static boolean isCenter(class_4538 level, class_2338 pos){
        if (level.method_8321(pos) instanceof IMultiBlockEntity entity) {
            return entity.isCenter();
        }
        return false;
    }

    default boolean isCenter(){
        return getOffset().equals(new class_2338(0,0,0));
    }

    default void setCenter(class_2338 center){
       setOffset(getBlockEntity().method_11016().method_10059(center));
    };

    default class_2338 getCenter(){
       return getBlockEntity().method_11016().method_10059(getOffset());
    }

    default class_2586 getBlockEntity(){
        if (this instanceof class_2586 entity){
            return entity;
        } else {
            throw new RuntimeException(this.getClass().getSimpleName() + " is not implemented on a BlockEntity");
        }
    }
}
