package net.nikdo53.tinymultiblocklib.client;

import net.minecraft.class_1921;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.nikdo53.tinymultiblocklib.blockentities.IMultiBlockEntity;
import net.nikdo53.tinymultiblocklib.components.PreviewMode;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoBlockRenderer;

/**
 * Works just like the GeoBlockRenderer
 * but automatically changes the multiblock based on its preview mode
 * */
public abstract class GeoMultiblockRenderer<T extends class_2586 & GeoAnimatable & IMultiBlockEntity> extends GeoBlockRenderer<T> implements IMultiblockRenderHelper {
    public GeoMultiblockRenderer(GeoModel<T> model) {
        super(model);
    }

    @Override
    public class_1921 getRenderType(T animatable, class_2960 texture, @Nullable class_4597 bufferSource, float partialTick) {
        return getRenderType(animatable.getPreviewMode(), texture, super.getRenderType(animatable, texture, bufferSource, partialTick));
    }

    @Override
    public void actuallyRender(class_4587 poseStack, T animatable, BakedGeoModel model, class_1921 renderType, class_4597 bufferSource, class_4588 buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (!animatable.isCenter()) return;
        float[] rgba = animatable.getPreviewMode().applyColorsFloat(red,green,blue,alpha);

        super.actuallyRender(poseStack, animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, rgba[0], rgba[1], rgba[2], rgba[3]);
    }
}
