package net.nikdo53.tinymultiblocklib.block;

import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_4538;
import net.nikdo53.tinymultiblocklib.blockentities.IMultiBlockEntity;
import net.nikdo53.tinymultiblocklib.components.PreviewMode;
import net.nikdo53.tinymultiblocklib.components.SyncedStatePropertiesBuilder;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;

public abstract class AbstractMultiBlock extends class_2248 implements IMovableMultiblock, class_2343 {
    /**
     * The BlockState of the multiblocks center block, ideally you should forward all logic to this block
     * <p>
     * Note that even though it's called "CENTER", it isn't necessarily the actual center.
     * The center is just where the block would be placed, if it were just a single block
     * @see #isCenter(BlockState)
     * @see #getCenter(BlockGetter, BlockPos)
     * */
    public static final class_2746 CENTER = class_2746.method_11825("center");
    private final SyncedStatePropertiesBuilder SYNCED_STATE_BUILDER = new SyncedStatePropertiesBuilder();

    public AbstractMultiBlock(class_2251 properties) {
        super(properties);
        if (getDirectionProperty() != null){
            this.method_9590(this.method_9595().method_11664().method_11657(CENTER, false).method_11657(getDirectionProperty(), class_2350.field_11043));
        } else {
            this.method_9590(this.method_9595().method_11664().method_11657(CENTER, false));
        }
    }

    @Override
    public SyncedStatePropertiesBuilder getSyncedStatePropertiesBuilder() {
        return SYNCED_STATE_BUILDER;
    }

    @Override
    public @Nullable class_2680 method_9605(class_1750 context) {
        return getStateForPlacementHelper(context);
    }

    @Override
    public class_2464 method_9604(class_2680 state) {
        return getMultiblockRenderShape(state);
    }

    /**
     * Sorry for forcing everyone to override this, but its kinda important for performance and fixing visual glitches
     * <p>
     * If your block is a json model, return {@link class_2464#field_11458}
     * <p>
     * If your block has a BlockEntity renderer, return {@link class_2464#field_11456} for that specific block and  {@link class_2464#field_11455} everywhere else
     * @see #getStateForEachBlock(class_2680, class_2338, class_2338, class_1937, class_2350)  (BlockState, BlockPos) The function for setting a different blockstate to each block
     * */
    public abstract class_2464 getMultiblockRenderShape(class_2680 state);

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(CENTER);
        if (getDirectionProperty() != null) builder.method_11667(getDirectionProperty());
    }

    @Override
    public void method_9615(class_2680 state, class_1937 level, class_2338 pos, class_2680 oldState, boolean movedByPiston) {
        super.method_9615(state, level, pos, oldState, movedByPiston);

        onPlaceHelper(state, level, pos, oldState);
    }

    @Override
    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 level, class_2338 pos, class_2338 neighborPos) {
        return updateShapeHelper(state, level, pos);
    }

    @Override
    public boolean method_9558(class_2680 state, class_4538 level, class_2338 pos) {
        return canSurviveHelper(state, level, pos);
    }

    @Override
    public class_2680 method_9576(class_1937 level, class_2338 pos, class_2680 state, class_1657 player) {
        preventCreativeDrops(player, level, pos);
        return super.method_9576(level, pos, state, player);
    }
}
