package net.nikdo53.tinymultiblocklib.block;

import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.nikdo53.tinymultiblocklib.blockentities.IMultiBlockEntity;

import java.util.List;

public interface IExpandingMultiblock extends IMultiBlock {

    @Override
    default void onPlaceHelper(class_2680 state, class_1937 level, class_2338 pos, class_2680 oldState) {
        boolean willChangeShape = IMultiBlock.isCenter(state) && IMultiBlock.isMultiblock(oldState) && hasShapeChanged(state, level, pos, oldState);
        if (willChangeShape) {
            if (canChangeShape(state, level, pos)) {

                changeShape(state, level, pos, oldState);
                postChangeShape(state, level, pos, oldState);

            } else {
                cancelChangeShape(state, level, pos, oldState);
            }
            return;
        }

        IMultiBlock.super.onPlaceHelper(state, level, pos, oldState);
    }

    default boolean hasShapeChanged(class_2680 state, class_1937 level, class_2338 pos, class_2680 oldState) {
        class_2338 center = IMultiBlock.getCenter(level, pos);
        return !getFullBlockShape(center, oldState, level).equals(getFullBlockShapeNoCache(pos, state));
    }

    default void changeShape(class_2680 state, class_1937 level, class_2338 pos, class_2680 oldState) {
        if (level.method_8608()) return;

        IMultiBlock.invalidateCaches(level, pos);

        class_2338 center = IMultiBlock.getCenter(level, pos);
        List<class_2338> oldShape = getFullBlockShapeNoCache(pos, oldState);
        List<class_2338> shapeNew = getFullBlockShape(pos, state, level);


        oldShape.forEach(posOld -> {
            IMultiBlockEntity.setPlaced(level, posOld, false);

            if (!shapeNew.contains(posOld)) {
                level.method_8544(posOld);
                level.method_8652(posOld, class_2246.field_10124.method_9564(), 2);
            }

        });

        place(level, center, state);
    }

    default boolean canChangeShape(class_2680 state, class_1937 level, class_2338 pos) {
        class_2338 center = IMultiBlock.getCenter(level, pos);

        return getFullBlockShapeNoCache(center, state).stream().allMatch(posNew -> {
            class_2680 stateNew = level.method_8320(posNew);

            return (stateNew.method_45474() || IMultiBlock.isSameMultiblock(level, state, stateNew, center, posNew ))
                    && extraSurviveRequirements(level, posNew, state, posNew.method_10059(center))
                    && (entityUnobstructed(level, posNew, state, null));
        });
    }

    default void postChangeShape(class_2680 state, class_1937 level, class_2338 pos, class_2680 oldState) {
        getFullBlockShape(pos, state, level).forEach(posNew -> IMultiBlockEntity.setPlaced(level, posNew, true));
    }

    default void cancelChangeShape(class_2680 state, class_1937 level, class_2338 pos, class_2680 oldState){
        level.method_8652(pos, oldState, 2);
    }
}
