package net.nikdo53.tinymultiblocklib.blockentities;

import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_7225;
import net.nikdo53.tinymultiblocklib.block.IMultiBlock;
import net.nikdo53.tinymultiblocklib.components.PreviewMode;

import java.util.ArrayList;
import java.util.List;

public class AbstractMultiBlockEntity extends class_2586 implements IMultiBlockEntity{
    private class_2338 offset;
    private boolean isPlaced;
    private PreviewMode previewMode = PreviewMode.PLACED;
    private List<class_2338> BLOCK_SHAPE_CACHE = new ArrayList<>();

    public AbstractMultiBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.offset = new class_2338(0,0,0);
        this.isPlaced = false;
    }

    @Override
    protected void method_11007(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11007(tag, registries);
        tag.method_10566("offset", class_2512.method_10692(this.offset));
        tag.method_10556("placed", this.isPlaced);
    }

    @Override
    public class_2487 method_16887(class_7225.class_7874 registries) {
        class_2487 tag = super.method_16887(registries);
        method_11007(tag, registries);
        return tag;
    }

    @Override
    protected void method_11014(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11014(tag, registries);
        this.offset = class_2512.method_10691(tag, "offset").orElseGet(() -> this.offset);
        this.isPlaced = tag.method_10577("placed");

        if (tag.method_10545("center")) // For maintaining compatibility with TMBL < 2.1
            setCenter(class_2512.method_10691(tag, "center").orElseGet(this::method_11016));
    }

    @Override
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585(this);
    }

    @Override
    public class_2338 getOffset() {
        return offset;
    }

    @Override
    public void setOffset(class_2338 offset) {
       this.offset = offset;
    }

    @Override
    public boolean isPlaced() {
        return isPlaced;
    }

    @Override
    public void setPlaced(boolean placed) {
        this.isPlaced = placed;
    }

    @Override
    public List<class_2338> getFullBlockShapeCache() {
        return BLOCK_SHAPE_CACHE;
    }

    @Override
    public void setFullBlockShapeCache(List<class_2338> blockPosList) {
        BLOCK_SHAPE_CACHE = blockPosList;
    }

    @Override
    public void invalidateCaches() {
        BLOCK_SHAPE_CACHE = new ArrayList<>();
    }

    @Override
    public PreviewMode getPreviewMode() {
        return previewMode;
    }

    @Override
    public void setPreviewMode(PreviewMode mode) {
        this.previewMode = mode;
    }
}
