package net.nikdo53.tinymultiblocklib.mixin;

import net.minecraft.class_2338;
import net.minecraft.class_2464;
import net.minecraft.class_2680;
import net.minecraft.class_638;
import net.minecraft.class_761;
import net.nikdo53.tinymultiblocklib.block.IMultiBlock;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_638.class)
public class ClientLevelMixin {

    @Shadow
    @Final
    private class_761 levelRenderer;

    /**
     * Transfers destroyProgress to the center block
     * */
    @Inject(method = "destroyBlockProgress", at = @At(value = "HEAD"), cancellable = true)
    public void destroyBlockProgress(int breakerId, class_2338 pos, int progress, CallbackInfo ci) {
        class_638 level = (class_638) (Object)this;
        class_2680 blockState = level.method_8320(pos);

        if (IMultiBlock.isMultiblock(blockState) && !blockState.method_26217().equals(class_2464.field_11458)) {
            levelRenderer.method_8569(breakerId, IMultiBlock.getCenter(level, pos), progress);
            ci.cancel();
        }
    }
}
