/*
 * Decompiled with CFR 0.152.
 */
package net.nikdo53.tinymultiblocklib.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.nikdo53.tinymultiblocklib.block.IMovableMultiblock;
import net.nikdo53.tinymultiblocklib.components.SyncedStatePropertiesBuilder;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractMultiBlock
extends Block
implements IMovableMultiblock,
EntityBlock {
    public static final BooleanProperty CENTER = BooleanProperty.create((String)"center");
    private final SyncedStatePropertiesBuilder SYNCED_STATE_BUILDER = new SyncedStatePropertiesBuilder();

    public AbstractMultiBlock(BlockBehaviour.Properties properties) {
        super(properties);
        if (this.getDirectionProperty() != null) {
            this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)CENTER, (Comparable)Boolean.valueOf(false))).setValue((Property)this.getDirectionProperty(), (Comparable)Direction.NORTH));
        } else {
            this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)CENTER, (Comparable)Boolean.valueOf(false)));
        }
    }

    @Override
    public SyncedStatePropertiesBuilder getSyncedStatePropertiesBuilder() {
        return this.SYNCED_STATE_BUILDER;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.getStateForPlacementHelper(context);
    }

    public RenderShape getRenderShape(BlockState state) {
        return this.getMultiblockRenderShape(state);
    }

    public abstract RenderShape getMultiblockRenderShape(BlockState var1);

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{CENTER});
        if (this.getDirectionProperty() != null) {
            builder.add(new Property[]{this.getDirectionProperty()});
        }
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        super.onPlace(state, level, pos, oldState, movedByPiston);
        this.onPlaceHelper(state, level, pos, oldState);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        return this.updateShapeHelper(state, level, pos);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return this.canSurviveHelper(state, level, pos);
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        this.preventCreativeDrops(player, level, pos);
        return super.playerWillDestroy(level, pos, state, player);
    }
}

