/*
 * Decompiled with CFR 0.152.
 */
package net.nikdo53.tinymultiblocklib.block;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.nikdo53.tinymultiblocklib.block.IMultiBlock;
import net.nikdo53.tinymultiblocklib.blockentities.IMultiBlockEntity;

public interface IExpandingMultiblock
extends IMultiBlock {
    @Override
    default public void onPlaceHelper(BlockState state, Level level, BlockPos pos, BlockState oldState) {
        boolean willChangeShape;
        boolean bl = willChangeShape = IMultiBlock.isCenter(state) && IMultiBlock.isMultiblock(oldState) && this.hasShapeChanged(state, level, pos, oldState);
        if (willChangeShape) {
            if (this.canChangeShape(state, level, pos)) {
                this.changeShape(state, level, pos, oldState);
                this.postChangeShape(state, level, pos, oldState);
            } else {
                this.cancelChangeShape(state, level, pos, oldState);
            }
            return;
        }
        IMultiBlock.super.onPlaceHelper(state, level, pos, oldState);
    }

    default public boolean hasShapeChanged(BlockState state, Level level, BlockPos pos, BlockState oldState) {
        BlockPos center = IMultiBlock.getCenter((BlockGetter)level, pos);
        return !this.getFullBlockShape(center, oldState, (BlockGetter)level).equals(this.getFullBlockShapeNoCache(pos, state));
    }

    default public void changeShape(BlockState state, Level level, BlockPos pos, BlockState oldState) {
        if (level.isClientSide()) {
            return;
        }
        IMultiBlock.invalidateCaches((BlockGetter)level, pos);
        BlockPos center = IMultiBlock.getCenter((BlockGetter)level, pos);
        List<BlockPos> oldShape = this.getFullBlockShapeNoCache(pos, oldState);
        List<BlockPos> shapeNew = this.getFullBlockShape(pos, state, (BlockGetter)level);
        oldShape.forEach(posOld -> {
            IMultiBlockEntity.setPlaced((LevelReader)level, posOld, false);
            if (!shapeNew.contains(posOld)) {
                level.removeBlockEntity(posOld);
                level.setBlock(posOld, Blocks.AIR.defaultBlockState(), 2);
            }
        });
        this.place(level, center, state);
    }

    default public boolean canChangeShape(BlockState state, Level level, BlockPos pos) {
        BlockPos center = IMultiBlock.getCenter((BlockGetter)level, pos);
        return this.getFullBlockShapeNoCache(center, state).stream().allMatch(posNew -> {
            BlockState stateNew = level.getBlockState(posNew);
            return (stateNew.canBeReplaced() || IMultiBlock.isSameMultiblock(level, state, stateNew, center, posNew)) && this.extraSurviveRequirements((LevelReader)level, (BlockPos)posNew, state, posNew.subtract((Vec3i)center)) && this.entityUnobstructed((CollisionGetter)level, (BlockPos)posNew, state, null);
        });
    }

    default public void postChangeShape(BlockState state, Level level, BlockPos pos, BlockState oldState) {
        this.getFullBlockShape(pos, state, (BlockGetter)level).forEach(posNew -> IMultiBlockEntity.setPlaced((LevelReader)level, posNew, true));
    }

    default public void cancelChangeShape(BlockState state, Level level, BlockPos pos, BlockState oldState) {
        level.setBlock(pos, oldState, 2);
    }
}

