/*
 * Decompiled with CFR 0.152.
 */
package net.nikdo53.tinymultiblocklib.block;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.nikdo53.tinymultiblocklib.block.IMultiBlock;
import net.nikdo53.tinymultiblocklib.components.PropertyWrapper;
import net.nikdo53.tinymultiblocklib.components.SyncedStatePropertiesBuilder;

public interface IMBStateSyncer {
    public SyncedStatePropertiesBuilder getSyncedStatePropertiesBuilder();

    default public List<PropertyWrapper<?>> getSyncedStateProperties() {
        SyncedStatePropertiesBuilder syncedStatePropertiesBuilder = this.getSyncedStatePropertiesBuilder();
        if (!syncedStatePropertiesBuilder.isInitialized()) {
            this.createSyncedBlockStates(syncedStatePropertiesBuilder);
            syncedStatePropertiesBuilder.setInitialized();
        }
        return syncedStatePropertiesBuilder.getProperties();
    }

    default public void createSyncedBlockStates(SyncedStatePropertiesBuilder builder) {
        DirectionProperty directionProperty = this.getMultiBlock().getDirectionProperty();
        if (directionProperty != null) {
            builder.add(directionProperty);
        }
    }

    public static <T extends Comparable<T>> void setBlockStates(Level level, BlockPos pos, List<PropertyWrapper<?>> stateValuePairs) {
        IMBStateSyncer.setBlockStates(level, pos, 3, stateValuePairs);
    }

    public static <T extends Comparable<T>> void setBlockState(Level level, BlockPos pos, Property<T> property, T value) {
        IMBStateSyncer.setBlockStates(level, pos, 3, List.of(new PropertyWrapper<T>(property, value)));
    }

    public static <T extends Comparable<T>> void setBlockStates(Level level, BlockPos pos, int flags, List<PropertyWrapper<?>> properties) {
        IMultiBlock.getFullShape(level, pos).forEach(pos1 -> {
            BlockState state = level.getBlockState(pos1);
            for (PropertyWrapper propertyWrapper : properties) {
                state = propertyWrapper.applyTo(state);
            }
            level.setBlock(pos1, state, flags);
        });
    }

    default public void syncBlockStates(Level level, BlockPos pos, BlockState state) {
        ArrayList list = new ArrayList(this.getSyncedStateProperties());
        BlockPos centerPos = IMultiBlock.getCenter((BlockGetter)level, pos);
        BlockState centerState = level.getBlockState(centerPos);
        boolean isCenter = IMultiBlock.isCenter(state);
        for (PropertyWrapper propertyWrapper : list) {
            propertyWrapper.captureValue(state);
            if (isCenter) continue;
            centerState = propertyWrapper.applyTo(centerState);
        }
        if (!isCenter) {
            level.setBlock(centerPos, centerState, 2);
            return;
        }
        IMBStateSyncer.setBlockStates(level, pos, list);
    }

    private IMultiBlock getMultiBlock() {
        IMBStateSyncer iMBStateSyncer = this;
        if (iMBStateSyncer instanceof IMultiBlock) {
            IMultiBlock block = (IMultiBlock)iMBStateSyncer;
            return block;
        }
        throw new RuntimeException(this.getClass().getSimpleName() + " is not implemented on an IMultiBlock");
    }
}

