/*
 * Decompiled with CFR 0.152.
 */
package net.nikdo53.tinymultiblocklib.block;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.nikdo53.tinymultiblocklib.Constants;
import net.nikdo53.tinymultiblocklib.block.AbstractMultiBlock;
import net.nikdo53.tinymultiblocklib.block.IMBStateSyncer;
import net.nikdo53.tinymultiblocklib.blockentities.IMultiBlockEntity;

public interface IMultiBlock
extends IMBStateSyncer {
    public List<BlockPos> makeFullBlockShape(@Nullable Direction var1, BlockPos var2, BlockState var3);

    public static List<BlockPos> posStreamToList(Stream<BlockPos> posStream) {
        return new ArrayList<BlockPos>(posStream.map(BlockPos::immutable).toList());
    }

    @Nullable
    default public DirectionProperty getDirectionProperty() {
        return null;
    }

    @Nullable
    default public Direction getDirection(BlockState state) {
        if (this.getDirectionProperty() != null) {
            return (Direction)state.getValue((Property)this.getDirectionProperty());
        }
        return null;
    }

    default public List<BlockPos> getFullBlockShapeNoCache(BlockPos center, BlockState state) {
        List<BlockPos> list = this.getDirectionProperty() == null ? this.makeFullBlockShape(null, center, state) : this.makeFullBlockShape((Direction)state.getValue((Property)this.getDirectionProperty()), center, state);
        HashSet<BlockPos> set = new HashSet<BlockPos>(list);
        if (set.size() < list.size()) {
            Constants.LOGGER.error("Multiblock {} at {} has overlapping blocks in it's shape, this is likely caused by the BlockPos being mutable. Either map them to BlockPos::immutable or use IMultiBlock.posStreamToList()", (Object)state.toString(), (Object)center);
        }
        return list;
    }

    default public List<BlockPos> getFullBlockShape(BlockPos pos, BlockState state, BlockGetter level) {
        BlockPos center = IMultiBlock.getCenter(level, pos);
        BlockEntity blockEntity = level.getBlockEntity(center);
        if (!(blockEntity instanceof IMultiBlockEntity)) {
            return this.getFullBlockShapeNoCache(center, state);
        }
        IMultiBlockEntity blockEntity2 = (IMultiBlockEntity)blockEntity;
        if (blockEntity2.getFullBlockShapeCache().isEmpty()) {
            List<BlockPos> blockPosList = this.getFullBlockShapeNoCache(center, state);
            blockPosList.forEach(BlockPos::immutable);
            blockEntity2.setFullBlockShapeCache(blockPosList);
            return blockPosList;
        }
        return blockEntity2.getFullBlockShapeCache();
    }

    public static List<BlockPos> getFullShape(Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof IMultiBlock) {
            IMultiBlock multiBlock = (IMultiBlock)block;
            return multiBlock.getFullBlockShape(pos, state, (BlockGetter)level);
        }
        return List.of(pos);
    }

    public static void invalidateCaches(BlockGetter level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(IMultiBlock.getCenter(level, pos));
        if (blockEntity instanceof IMultiBlockEntity) {
            IMultiBlockEntity blockEntity2 = (IMultiBlockEntity)blockEntity;
            blockEntity2.invalidateCaches();
        }
    }

    default public BlockState getStateForEachBlock(BlockState state, BlockPos pos, BlockPos centerOffset, Level level, @Nullable Direction direction) {
        return state;
    }

    default public void onPlaceHelper(BlockState state, Level level, BlockPos pos, BlockState oldState) {
        boolean isPlaced = IMultiBlockEntity.isPlaced((LevelReader)level, pos);
        if (isPlaced) {
            this.syncBlockStates(level, pos, state);
        }
        if (IMultiBlock.isCenter(state) && !isPlaced) {
            this.place(level, pos, state);
        }
    }

    default public void place(Level level, BlockPos centerPos, BlockState stateOriginal) {
        this.prepareForPlace(level, centerPos, stateOriginal).forEach(pair -> {
            IMultiBlockEntity entity;
            BlockEntity patt0$temp;
            int flags = 66;
            BlockState stateNew = (BlockState)pair.getSecond();
            BlockPos posNew = (BlockPos)pair.getFirst();
            if (!level.getBlockState(posNew).equals(stateNew)) {
                level.setBlock(posNew, stateNew, flags);
            }
            if ((patt0$temp = level.getBlockEntity(posNew)) instanceof IMultiBlockEntity && !(entity = (IMultiBlockEntity)patt0$temp).getCenter().equals((Object)centerPos)) {
                entity.setCenter(centerPos);
                entity.getBlockEntity().setChanged();
            }
        });
    }

    default public List<Pair<BlockPos, BlockState>> prepareForPlace(Level level, BlockPos centerPos, BlockState stateOriginal) {
        ArrayList<Pair<BlockPos, BlockState>> list = new ArrayList<Pair<BlockPos, BlockState>>();
        this.getFullBlockShape(centerPos, stateOriginal, (BlockGetter)level).forEach(posNew -> {
            posNew = posNew.immutable();
            BlockState stateNew = (BlockState)stateOriginal.setValue((Property)AbstractMultiBlock.CENTER, (Comparable)Boolean.valueOf(centerPos.equals(posNew)));
            stateNew = this.getStateForEachBlock(stateNew, (BlockPos)posNew, posNew.subtract((Vec3i)centerPos), level, this.getDirection(stateOriginal));
            list.add(new Pair(posNew, (Object)stateNew));
        });
        return list;
    }

    default public BlockState getStateForPlacementHelper(BlockPlaceContext context) {
        return this.getStateForPlacementHelper(context, context.getHorizontalDirection());
    }

    default public BlockState getStateForPlacementHelper(BlockPlaceContext context, Direction direction) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = (BlockState)this.self().defaultBlockState().setValue((Property)AbstractMultiBlock.CENTER, (Comparable)Boolean.valueOf(true));
        if (this.getDirectionProperty() != null) {
            state = (BlockState)state.setValue((Property)this.getDirectionProperty(), (Comparable)direction);
        }
        return this.canPlace((LevelReader)level, pos, state, (Entity)context.getPlayer(), false) ? state : null;
    }

    default public boolean canPlace(LevelReader level, BlockPos center, BlockState state, @Nullable Entity player, boolean ignoreEntities) {
        return this.getFullBlockShape(center, state, (BlockGetter)level).stream().allMatch(blockPos -> this.canReplaceBlock(level, (BlockPos)blockPos, level.getBlockState(blockPos)) && this.extraSurviveRequirements(level, (BlockPos)blockPos, state, blockPos.subtract((Vec3i)center)) && (this.entityUnobstructed((CollisionGetter)level, (BlockPos)blockPos, state, player) || ignoreEntities));
    }

    default public boolean canReplaceBlock(LevelReader level, BlockPos blockPos, BlockState state) {
        return state.canBeReplaced();
    }

    default public boolean entityUnobstructed(CollisionGetter level, BlockPos pos, BlockState state, @Nullable Entity player) {
        CollisionContext context = player == null ? CollisionContext.empty() : CollisionContext.of((Entity)player);
        return this.getFullBlockShape(pos, state, (BlockGetter)level).stream().allMatch(blockPos -> level.isUnobstructed(state, blockPos, context));
    }

    default public void destroy(BlockPos center, Level level, BlockState state, boolean dropBlock) {
        if (level.isClientSide()) {
            return;
        }
        List<BlockPos> blocks = this.getFullBlockShape(center, state, (BlockGetter)level);
        level.destroyBlock(center, false);
        blocks.forEach(pos -> {
            Block block;
            BlockState blockState = level.getBlockState(pos);
            if (blockState.is(block = state.getBlock())) {
                level.destroyBlock(pos, dropBlock);
            }
        });
    }

    default public boolean allBlocksPresent(LevelReader level, BlockPos pos, BlockState state) {
        IMultiBlockEntity entity;
        BlockEntity blockEntity;
        if (level.isClientSide()) {
            return true;
        }
        BlockPos center = IMultiBlock.getCenter((BlockGetter)level, pos);
        boolean ret = this.getFullBlockShape(center, state, (BlockGetter)level).stream().allMatch(blockPos -> level.getBlockState(blockPos).is(this.self()));
        boolean isMultiblock = IMultiBlock.isMultiblock((BlockGetter)level, pos);
        if (ret && (blockEntity = level.getBlockEntity(pos)) instanceof IMultiBlockEntity && !(entity = (IMultiBlockEntity)blockEntity).isPlaced() && isMultiblock) {
            this.getFullBlockShape(center, state, (BlockGetter)level).forEach(blockPos -> IMultiBlockEntity.setPlaced(level, blockPos, true));
        }
        return ret;
    }

    default public BlockState updateShapeHelper(BlockState state, LevelAccessor level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof IMultiBlockEntity) {
            IMultiBlockEntity entity = (IMultiBlockEntity)blockEntity;
            BlockPos centerPos = IMultiBlock.getCenter((BlockGetter)level, pos);
            boolean canSurvive = state.canSurvive((LevelReader)level, centerPos);
            if (!canSurvive) {
                this.destroy(entity.getCenter(), (Level)level, state, true);
                return Blocks.AIR.defaultBlockState();
            }
        } else {
            return Blocks.AIR.defaultBlockState();
        }
        return state;
    }

    default public boolean canSurviveHelper(BlockState state, LevelReader level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof IMultiBlockEntity) {
            IMultiBlockEntity entity = (IMultiBlockEntity)blockEntity;
            boolean extraSurvive = this.getFullBlockShape(pos, state, (BlockGetter)level).stream().allMatch(blockPos -> this.extraSurviveRequirements(level, (BlockPos)blockPos, state, entity.getOffset()));
            return (this.allBlocksPresent(level, pos, state) || !entity.isPlaced()) && extraSurvive;
        }
        return this.canPlace(level, pos, state, null, false);
    }

    @Deprecated
    default public boolean extraSurviveRequirements(LevelReader level, BlockPos pos, BlockState state) {
        return true;
    }

    default public boolean extraSurviveRequirements(LevelReader level, BlockPos pos, BlockState state, BlockPos centerOffset) {
        return this.extraSurviveRequirements(level, pos, state);
    }

    default public void preventCreativeDrops(Player player, Level level, BlockPos pos) {
        BlockEntity blockEntity;
        if (player.isCreative() && (blockEntity = level.getBlockEntity(pos)) instanceof IMultiBlockEntity) {
            IMultiBlockEntity entity = (IMultiBlockEntity)blockEntity;
            this.destroy(entity.getCenter(), level, level.getBlockState(pos), false);
        }
    }

    public static BlockPos getCenter(BlockGetter level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof IMultiBlockEntity) {
            IMultiBlockEntity entity = (IMultiBlockEntity)blockEntity;
            return entity.getCenter();
        }
        return pos;
    }

    public static BlockPos getOffset(BlockGetter level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof IMultiBlockEntity) {
            IMultiBlockEntity entity = (IMultiBlockEntity)blockEntity;
            return entity.getOffset();
        }
        return new BlockPos(0, 0, 0);
    }

    public static boolean isCenter(BlockState state) {
        return (Boolean)state.getValue((Property)AbstractMultiBlock.CENTER);
    }

    public static boolean isMultiblock(BlockState state) {
        return state.getBlock() instanceof IMultiBlock;
    }

    public static boolean isMultiblock(BlockGetter level, BlockPos pos) {
        return IMultiBlock.isMultiblock(level.getBlockState(pos));
    }

    default public VoxelShape voxelShapeHelper(BlockState state, BlockGetter level, BlockPos pos, VoxelShape shape) {
        return this.voxelShapeHelper(state, level, pos, shape, 0.0f, 0.0f, 0.0f);
    }

    default public VoxelShape voxelShapeHelper(BlockState state, BlockGetter level, BlockPos pos, VoxelShape shape, float xOffset, float yOffset, float zOffset) {
        return this.voxelShapeHelper(state, level, pos, shape, xOffset, yOffset, zOffset, false);
    }

    default public VoxelShape voxelShapeHelper(BlockState state, BlockGetter level, BlockPos pos, VoxelShape shape, float xOffset, float yOffset, float zOffset, boolean hasDirectionOffsets) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof IMultiBlockEntity) {
            IMultiBlockEntity entity = (IMultiBlockEntity)blockEntity;
            float x = (float)(-entity.getOffset().getX()) + xOffset;
            float y = (float)(-entity.getOffset().getY()) + yOffset;
            float z = (float)(-entity.getOffset().getZ()) + zOffset;
            if (this.getDirectionProperty() != null && hasDirectionOffsets) {
                switch ((Direction)state.getValue((Property)this.getDirectionProperty())) {
                    case EAST: {
                        x += 1.0f;
                        break;
                    }
                    case NORTH: {
                        x += 1.0f;
                        z -= 1.0f;
                        break;
                    }
                    case WEST: {
                        z -= 1.0f;
                    }
                }
            }
            return shape.move((double)x, (double)y, (double)z);
        }
        return shape;
    }

    public static boolean isSameMultiblock(Level level, BlockState state1, BlockState state2, BlockPos center, BlockPos posNew) {
        IMultiBlockEntity entity;
        BlockEntity blockEntity;
        return state1.getBlock().equals(state2.getBlock()) && (blockEntity = level.getBlockEntity(posNew)) instanceof IMultiBlockEntity && (entity = (IMultiBlockEntity)blockEntity).getCenter().equals((Object)center);
    }

    private Block self() {
        IMultiBlock iMultiBlock = this;
        if (iMultiBlock instanceof Block) {
            Block block = (Block)iMultiBlock;
            return block;
        }
        throw new RuntimeException(this.getClass().getSimpleName() + " is not implemented on a Block");
    }
}

