/*
 * Decompiled with CFR 0.152.
 */
package net.nikdo53.tinymultiblocklib.block;

import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.nikdo53.tinymultiblocklib.block.AbstractMultiBlock;
import net.nikdo53.tinymultiblocklib.block.IExpandingMultiblock;
import net.nikdo53.tinymultiblocklib.block.IMultiBlock;
import net.nikdo53.tinymultiblocklib.block.IPreviewableMultiblock;
import net.nikdo53.tinymultiblocklib.block.entity.TestMultiblockEntity;
import net.nikdo53.tinymultiblocklib.components.SyncedStatePropertiesBuilder;

public class TestBlock
extends AbstractMultiBlock
implements IPreviewableMultiblock,
IExpandingMultiblock {
    public static final VoxelShape SHAPE = TestBlock.makeShape();

    public TestBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    @Nullable
    public DirectionProperty getDirectionProperty() {
        return HorizontalDirectionalBlock.FACING;
    }

    @Override
    public void createSyncedBlockStates(SyncedStatePropertiesBuilder builder) {
        super.createSyncedBlockStates(builder);
        builder.add(BlockStateProperties.AGE_3);
    }

    @Override
    public List<BlockPos> makeFullBlockShape(@Nullable Direction direction, BlockPos center, BlockState state) {
        assert (direction != null);
        int size = (Integer)state.getValue((Property)BlockStateProperties.AGE_3);
        if (size < 1) {
            size = 1;
        }
        List<BlockPos> list = IMultiBlock.posStreamToList(BlockPos.betweenClosedStream((BlockPos)center.relative(Direction.NORTH, size).relative(Direction.EAST, size), (BlockPos)center.above(size)));
        list.add(center.above().relative(direction, 3));
        return new HashSet<BlockPos>(list).stream().toList();
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.AGE_3});
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        int value = (Integer)state.getValue((Property)BlockStateProperties.AGE_3) + 1;
        if (value > 3) {
            value = 0;
        }
        Direction direction = (Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING);
        this.moveMultiblock(level, pos, state, direction);
        return InteractionResult.SUCCESS;
    }

    @Override
    public RenderShape getMultiblockRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TestMultiblockEntity(pos, state);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.block();
    }

    public static VoxelShape makeShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)-1.0, (double)0.0, (double)0.0, (double)1.0, (double)2.0, (double)2.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)-1.5, (double)0.75, (double)0.75, (double)1.5, (double)1.25, (double)1.25), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)-1.0, (double)0.75, (double)0.75, (double)2.0, (double)1.25, (double)1.25), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)-2.0, (double)0.75, (double)0.75, (double)1.0, (double)1.25, (double)1.25), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)-1.5, (double)0.75, (double)0.75, (double)1.5, (double)1.25, (double)1.25), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)-1.5, (double)1.5, (double)0.75, (double)1.5, (double)2.0, (double)1.25), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)-1.5, (double)0.0, (double)0.75, (double)1.5, (double)0.5, (double)1.25), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)-1.5, (double)0.75, (double)1.5, (double)1.5, (double)1.25, (double)2.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)-1.5, (double)0.75, (double)0.0, (double)1.5, (double)1.25, (double)0.5), (BooleanOp)BooleanOp.OR);
        return shape;
    }
}

