/*
 * Decompiled with CFR 0.152.
 */
package net.nikdo53.tinymultiblocklib.blockentities;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.nikdo53.tinymultiblocklib.blockentities.IMultiBlockEntity;
import net.nikdo53.tinymultiblocklib.components.PreviewMode;

public class AbstractMultiBlockEntity
extends BlockEntity
implements IMultiBlockEntity {
    private BlockPos offset;
    private boolean isPlaced = false;
    private PreviewMode previewMode = PreviewMode.PLACED;
    private List<BlockPos> BLOCK_SHAPE_CACHE = new ArrayList<BlockPos>();

    public AbstractMultiBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.offset = new BlockPos(0, 0, 0);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("offset", NbtUtils.writeBlockPos((BlockPos)this.offset));
        tag.putBoolean("placed", this.isPlaced);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        this.saveAdditional(tag, registries);
        return tag;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.offset = NbtUtils.readBlockPos((CompoundTag)tag, (String)"offset").orElseGet(() -> this.offset);
        this.isPlaced = tag.getBoolean("placed");
        if (tag.contains("center")) {
            this.setCenter(NbtUtils.readBlockPos((CompoundTag)tag, (String)"center").orElseGet(() -> ((AbstractMultiBlockEntity)this).getBlockPos()));
        }
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @Override
    public BlockPos getOffset() {
        return this.offset;
    }

    @Override
    public void setOffset(BlockPos offset) {
        this.offset = offset;
    }

    @Override
    public boolean isPlaced() {
        return this.isPlaced;
    }

    @Override
    public void setPlaced(boolean placed) {
        this.isPlaced = placed;
    }

    @Override
    public List<BlockPos> getFullBlockShapeCache() {
        return this.BLOCK_SHAPE_CACHE;
    }

    @Override
    public void setFullBlockShapeCache(List<BlockPos> blockPosList) {
        this.BLOCK_SHAPE_CACHE = blockPosList;
    }

    @Override
    public void invalidateCaches() {
        this.BLOCK_SHAPE_CACHE = new ArrayList<BlockPos>();
    }

    @Override
    public PreviewMode getPreviewMode() {
        return this.previewMode;
    }

    @Override
    public void setPreviewMode(PreviewMode mode) {
        this.previewMode = mode;
    }
}

